WITH Ada.Text_IO;
WITH Ada.Integer_Text_IO;
PROCEDURE Squares IS
------------------------------------------------------------------
--| Displays a list of integer values and their squares.   
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
------------------------------------------------------------------

  MaxNum : CONSTANT Natural := 10;
  NumSquared : Natural;   -- output - square of Num
 
BEGIN -- Squares   

  Ada.Text_IO.Put(Item => "        Num    Num ** 2 ");
  Ada.Text_IO.New_Line;
  Ada.Text_IO.Put(Item => "        ---    ---------");
  Ada.Text_IO.New_Line;

  FOR Num IN 1..MaxNum LOOP
    NumSquared := Num ** 2; 
    Ada.Integer_Text_IO.Put (Item => Num, Width => 10);
    Ada.Integer_Text_IO.Put (Item => NumSquared, Width => 10);
    Ada.Text_IO.New_Line;
  END LOOP;

END Squares;
