WITH Ada.Text_IO;
WITH Ada.Float_Text_IO;
PROCEDURE Modified_Payroll IS
------------------------------------------------------------------
--| Computes and displays gross pay and net pay given an hourly
--| rate and number of hours worked.  Deducts a tax of $25 if
--| gross salary exceeds $100; otherwise, deducts no tax.
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
------------------------------------------------------------------

  SUBTYPE NonNegFloat IS Float RANGE 0.0 .. Float'Last;
  
  TaxBracket : CONSTANT NonNegFloat := 100.00;
                             -- maximum salary for no deduction
  Tax :        CONSTANT NonNegFloat := 25.00;   -- tax amount
 
  Hours : NonNegFloat; -- inputs - hours worked, hourly rate  
  Rate:   NonNegFloat; 
  Gross:  NonNegFloat; -- outputs - gross pay, net pay        
  Net:    NonNegFloat; 
 
BEGIN -- Modified_Payroll   

  -- Enter Hours and Rate   
  Ada.Text_IO.Put (Item => "Hours worked > ");
  Ada.Float_Text_IO.Get (Item => Hours);  
  Ada.Text_IO.Put (Item => "Hourly rate $");
  Ada.Float_Text_IO.Get (Item => Rate);  
  Ada.Text_IO.New_Line;
 
  -- Compute gross salary   
  Gross := Hours * Rate;
 
  -- Compute net salary   
  IF Gross > TaxBracket THEN
    Net := Gross - Tax;     -- Deduct a tax amount  
  ELSE
    Net := Gross;           -- Deduct no tax  
  END IF;
 
  -- Print Gross and Net   
  Ada.Text_IO.Put (Item => "Gross salary is $");
  Ada.Float_Text_IO.Put (Item => Gross, Fore => 1, Aft => 2, Exp => 0);
  Ada.Text_IO.New_Line;
  Ada.Text_IO.Put (Item => "Net salary is $");
  Ada.Float_Text_IO.Put (Item => Net, Fore => 1, Aft => 2, Exp => 0);
  Ada.Text_IO.New_Line;

END Modified_Payroll;
