WITH Ada.Text_IO;
WITH Screen;
WITH Database;
PROCEDURE Employee_UI IS
------------------------------------------------------------------
--| Shell of menu-driven user interface for Employee Database
--| when correct input is entered, a message is displayed
--| instead of actually executing the command .
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
------------------------------------------------------------------

  TYPE MenuValues IS (I,      -- Initialize database
                      A,      -- Add a record
                      D,      -- Delete a record
                      F,      -- retrieve (Find) and display a record
                      R,      -- find and Replace a record
                      P,      -- Display all records
                      Q);     -- Quit the program

  PACKAGE Menu_IO IS
    NEW Ada.Text_IO.Enumeration_IO (Enum => MenuValues);

  MenuSelection : MenuValues;

BEGIN -- Employee_UI

  LOOP -- main program loop

    Screen.ClearScreen;
    Screen.MoveCursor (Row => 5, Column => 20);
    Ada.Text_IO.Put (Item => "Select one of the operations below.");
    Screen.MoveCursor (Row => 7, Column => 20);
    Ada.Text_IO.Put (Item => "I  Initialize the Employee Database");
    Screen.MoveCursor (Row => 8, Column => 20);
    Ada.Text_IO.Put (Item => "A  Add a New Employee to the Database");
    Screen.MoveCursor (Row => 9, Column => 20);
    Ada.Text_IO.Put (Item => "D  Delete an Employee from the Database");
    Screen.MoveCursor (Row => 10, Column => 20);
    Ada.Text_IO.Put (Item => "F  Find and Display One Employee");
    Screen.MoveCursor (Row => 11, Column => 20);
    Ada.Text_IO.Put (Item => "R  Replace Old Record with New One");
    Screen.MoveCursor (Row => 11, Column => 20);
    Ada.Text_IO.Put (Item => "P  Display All Records in the Database");
    Screen.MoveCursor (Row => 12, Column => 20);
    Ada.Text_IO.Put (Item => "Q  Exit the program");

    LOOP
      BEGIN -- exception handler block

        Screen.MoveCursor (Row => 14, Column => 20);
        Ada.Text_IO.Put ("Please type a command, then press Enter > ");

        -- this statement will raise Data_Error if input is invalid
        Menu_IO.Get (Item => MenuSelection);

        -- these statements will be executed only if the input is correct
        -- otherwise, control passes to exception handler
        Screen.MoveCursor (Row => 15, Column => 20);
        Ada.Text_IO.Put ("Thank you for correct input.");
        Ada.Text_IO.New_Line;
        EXIT;      -- valid data; go ahead to process it

      EXCEPTION    -- invalid data
        
        WHEN Ada.Text_IO.Data_Error =>
          Screen.Beep;
          Screen.MoveCursor (Row => 15, Column => 20);
          Ada.Text_IO.Put (Item => "Value entered is not a command.");
          Ada.Text_IO.New_Line;
          DELAY 1.0;
          Ada.Text_IO.Skip_Line;
          Screen.MoveCursor (Row => 15, Column => 20);
          Ada.Text_IO.Put (Item => "                               ");
        WHEN OTHERS =>
          Screen.Beep;
          Screen.MoveCursor (Row => 15, Column => 20);
          Ada.Text_IO.Put (Item => "Unknown error; try again, please.");
          Ada.Text_IO.New_Line;
          DELAY 1.0;
          Ada.Text_IO.Skip_Line;
          Screen.MoveCursor (Row => 15, Column => 20);
          Ada.Text_IO.Put (Item => "                                 ");
        
      END;         -- of exception handler block

    END LOOP;

    Screen.MoveCursor (Row =>22, Column => 20);
    CASE MenuSelection IS
      WHEN I =>
        Ada.Text_IO.Put (Item => "I entered; here we'd initialize");
      WHEN A =>
        Ada.Text_IO.Put (Item => "A entered; here we'd insert");
      WHEN D =>
        Ada.Text_IO.Put (Item => "D entered; here we'd delete");
      WHEN F =>
        Ada.Text_IO.Put (Item => "F entered; here we'd find");
      WHEN R =>
        Ada.Text_IO.Put (Item => "R entered; here we'd replace");
      WHEN P =>
        Ada.Text_IO.Put (Item => "P entered; here we'd display all");
      WHEN Q =>
        Ada.Text_IO.Put (Item => "Q entered; have a niiiiccce day.....");
        EXIT;   -- the main loop and quit the program
    END CASE;

    Ada.Text_IO.New_Line;
    DELAY 2.0;

  END LOOP;

END Employee_UI;
