WITH Ada.Text_IO;
WITH Ada.Integer_Text_IO;
PROCEDURE Phone_Service IS
------------------------------------------------------------------
--| Shows sorting of unconstrained arrays and slices
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: September 1995                                     
------------------------------------------------------------------

  SUBTYPE DayRange IS Natural  RANGE 0..6;
  SUBTYPE Weekdays IS DayRange RANGE 0..4;
  SUBTYPE Weekend  IS DayRange RANGE 5..6;

  TYPE Days IS (Mon, Tue, Wed, Thu, Fri, Sat, Sun);
  TYPE CallRecord IS RECORD
    DayOfWeek    : Days;
    NumberOfCalls: Natural;
  END RECORD;
    
  TYPE Callers IS ARRAY(DayRange RANGE <>) of CallRecord;

  PACKAGE Days_IO IS NEW Ada.Text_IO.Enumeration_IO(Enum => Days);

  ThisWeek:       Callers(DayRange);
  WeekdayCallers: Callers(Weekdays);
  WeekendCallers: Callers(Weekend);

  PROCEDURE DisplayCallers (List: Callers) IS
  -- Pre:  List is defined
  -- Post: display all elements in the vector

  BEGIN -- DisplayCallers
    FOR Count IN List'Range LOOP
      Days_IO.Put  (Item=>List(Count).DayOfWeek, Width=>3);
      Ada.Integer_Text_IO.Put(Item=>List(Count).NumberOfCalls, Width=>4);
      Ada.Text_IO.New_Line;
    END LOOP;
    Ada.Text_IO.New_Line;
  END DisplayCallers;


  PROCEDURE Exchange(Value1, Value2: IN OUT CallRecord) IS
  -- Pre:  Value1 and Value2 are defined
  -- Post: Value1 and Value2 are interchanged

    TempValue: CallRecord;

  BEGIN -- Exchange
    TempValue := Value1;
    Value1    := Value2;
    Value2    := TempValue;
  END Exchange;


  PROCEDURE SelectSort(List: IN OUT Callers) IS
  -- Pre:  List is defined
  -- Post: elements of List are arranged in ascending order

    IndexOfMax: DayRange;

  BEGIN

    FOR PositionToFill IN List'First..List'Last - 1 LOOP

      -- Find the element in subarray 1..PositionToFill with largest Score
      IndexOfMax := PositionToFill;

      FOR ItemToCompare IN PositionToFill + 1..List'Last LOOP
        IF List(ItemToCompare).NumberOfCalls 
         < List(PositionToFill).NumberOfCalls THEN
          IndexOfMax := ItemToCompare;
        END IF;
      END LOOP;
      -- assert: element at List(PositionToFill) is smallest in subarray

      IF IndexOfMax /= PositionToFill THEN
        Exchange(List(PositionToFill),List(IndexOfMax));
      END IF;

    END LOOP;

  END SelectSort;


BEGIN -- Phone_Service

  ThisWeek := ((Mon, 12), (Tue, 23), (Wed, 100), (Thu, 40), 
               (Fri, 52), (Sat, 17), (Sun,   2));
  WeekdayCallers := ThisWeek(Weekdays);
  WeekendCallers := ThisWeek(Weekend);

  Ada.Text_IO.Put(Item=> "Testing SelectSort for telephone callers");
  Ada.Text_IO.New_Line;
  Ada.Text_IO.Put(Item=> "Here is ThisWeek before sorting.");
  Ada.Text_IO.New_Line;
  DisplayCallers(List => ThisWeek);
  Ada.Text_IO.New_Line;
  
  SelectSort(List => ThisWeek);
  Ada.Text_IO.Put(Item=> "Here is ThisWeek after upward sorting.");
  Ada.Text_IO.New_Line;
  DisplayCallers(List => ThisWeek);
  Ada.Text_IO.New_Line;

  Ada.Text_IO.Put(Item=> "Here is WeekdayCallers before sorting.");
  Ada.Text_IO.New_Line;
  DisplayCallers(List => WeekdayCallers);
  Ada.Text_IO.New_Line;
  
  SelectSort(List => WeekdayCallers);
  Ada.Text_IO.Put(Item=> "Here is WeekdayCallers after upward sorting.");
  Ada.Text_IO.New_Line;
  DisplayCallers(List => WeekdayCallers);
  Ada.Text_IO.New_Line;

  Ada.Text_IO.Put(Item=> "Here is the WeekendCallers before sorting.");
  Ada.Text_IO.New_Line;
  DisplayCallers(List => WeekendCallers);
  Ada.Text_IO.New_Line;
  
  SelectSort(List => WeekendCallers);
  Ada.Text_IO.Put(Item=> "Here is WeekendCallers after upward sorting.");
  Ada.Text_IO.New_Line;
  DisplayCallers(List => WeekendCallers);
  Ada.Text_IO.New_Line;

END Phone_Service;
