WITH Ada.Text_IO;
PROCEDURE One_Task IS
------------------------------------------------------------------
--| Show the declaration of a simple task type and one
--| variable of that type.
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: December 1995                                     
------------------------------------------------------------------

  -- A task type has a specification
  TASK TYPE SimpleTask (Message: Character);

  -- A task type has a body
  TASK BODY SimpleTask IS

  BEGIN -- SimpleTask
    
    FOR Count IN 1..10 LOOP
      Ada.Text_IO.Put("Hello from Task " & Message);
      Ada.Text_IO.New_Line;
    END LOOP;

  END SimpleTask;

  Task_A: SimpleTask(Message => 'A');

BEGIN -- One_Task

-- Unlike procedures, tasks are not "called" but are activated
-- automatically.

-- Task_A will start executing as soon as control reaches this
-- point, just after the BEGIN but before any of the main program's
-- statements are executed.

  NULL;

END One_Task;
