
------------------------------------------------------------
--        Name: Alden Dima
--      E-mail: dimaaa@seas.gwu.edu
--      School: The George Washington University
--              School of Engineering and Applied Science
--              Washington, D.C.
--       Class: CSci 298 - Independent Study
--     Project: Ada Curses Binding and Textual User Interface
--        File: adsetcol.adb "adatui-set_color.adb"
--        Date: 12/24/95 
-- Description: One of many adatui subunit bodies, this file
--              implements a subprogram declared in the adatui
--              package.
--   Revisions: 5/31/96 - AAD - Rewrote Ada-Curses binding to
--              enhance portability and maintainability.  Made
--              necessary changes in AdaTUI/TUIDemo to
--              accomodate new binding.  Made minor changes
--              to correct a problem using access types with
--              unconstrained arrays discovered by GNAT 3.03.
--              Eliminated several unused variables.
------------------------------------------------------------

separate (AdaTUI)
procedure set_color (
   window : pdcurses.A_WINDOW_T;
   color  : integer ) 
is
   attr : pdcurses.chtype;
   parm : pdcurses.chtype;
   temp : c.signed_int;
   subtype ch is pdcurses.chtype; 
   use type ch;

begin
   attr := ch(color) and ch(A_ATTR) and not ch(pdcurses.A_REVERSE);
   parm := pdcurses.color_pair ( ch(color) and ch(pdcurses.A_CHARTEXT) );
   temp := pdcurses.wattrset ( window, pdcurses.attr_t(parm or attr) );
end set_color;
