-----------------------------------------------------------------------
--
--  File:        words.adb
--  Description: HANGMAN word guessing
--  Rev:         0.2
--  Date:        03/01/97
--  Author:      Jerry van Dijk
--  Mail:        jerry@jvdsys.nextjk.stuyts.nl
--
--  Copyright (c) Jerry van Dijk, 1997
--  Forelstraat 211
--  2037 KV  HAARLEM
--  THE NETHERLANDS
--  tel int + 31 23 540 1052
--
--  Permission granted to use for any purpose, provided this copyright
--  remains attached and unmodified.
--
--  THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
--  IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
--  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
--
-----------------------------------------------------------------------
with Conio, Random;
use  Conio, Random;

package body Words is

   The_Words : array (Index) of Boolean := (others => False);

   procedure Used_Words (W : in Word) is
      J      : Index := 1;
      Result : Boolean := False;
   begin
      for I in Word_List'Range loop
         if Word_List (I).Value = W.Value then
            J := I;
         end if;
      end loop;
      if The_Words (J) = False then
         The_Words (J) := True;
         Number_Words_Used := Number_Words_Used + 1;
      end if;
   end Used_Words;

   function Pick_A_Word return Word is
   begin
      return Word_List (Get_Value);
   end Pick_A_Word;

   procedure Show (W : in Word) is
   begin
      Textcolor (Light_Red);
      Gotoxy (11, 21);
      Cputs ("Word: ");
      Textattr ((False, Black, Light_Gray));
      Putch (' ');
      for I in 1 .. W.Length loop
         if W.Guessed (I) = False then
            Cputs (". ");
         else
            Putch (W.Value (I));
            Putch (' ');
         end if;
      end loop;
      Textattr ((False, Blue, Light_Gray));
   end Show;

   function Is_Word_Guessed (W : in Word) return Boolean is
      Result : Boolean := True;
   begin
      for I in 1 .. W.Length loop
         if W.Guessed (I) = False then
            Result := False;
         end if;
      end loop;
      return Result;
   end Is_Word_Guessed;

   function Is_In_Word (W : in Word; C : in Character) return Boolean is
      Result : Boolean := False;
   begin
      for I in 1..W.Length loop
         if W.Value (I) = C then
            Result := True;
         end if;
      end loop;
      return Result;
   end Is_In_Word;

   procedure Set_Guessed (W : in out Word; C : in Character) is
   begin
      for I in 1..W.Length loop
         if W.Value (I) = C then
            W.Guessed (I) := True;
         end if;
      end loop;
   end Set_Guessed;

   procedure Forced_Word_Guessed (W : in out Word) is
   begin
      for I in 1..W.Length loop
         W.Guessed (I) := True;
      end loop;
   end Forced_Word_Guessed;

end Words;
