-----------------------------------------------------------------------
--
--  File:        input.adb
--  Description: HANGMAN input procedures
--  Rev:         0.2
--  Date:        03/01/97
--  Author:      Jerry van Dijk
--  Mail:        jerry@jvdsys.nextjk.stuyts.nl
--
--  Copyright (c) Jerry van Dijk, 1997
--  Forelstraat 211
--  2037 KV  HAARLEM
--  THE NETHERLANDS
--  tel int + 31 23 540 1052
--
--  Permission granted to use for any purpose, provided this copyright
--  remains attached and unmodified.
--
--  THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
--  IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
--  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
--
-----------------------------------------------------------------------
with Conio, Conio.Keys, Ada.Characters.Handling;
use  Conio, Conio.Keys, Ada.Characters.Handling;

package body Input is

   function Get_Guess return Character is
      C : Character;
   begin
      Textcolor (Dark_Gray);
      gotoxy (21, 24);
      Cputs ("  (<Esc> to exit)");
      Setcursortype (Solid);
      Textcolor (White);
      Gotoxy (11, 24);
      Cputs ("Guess: ");
      C := Getch;
      if C = K_NUL then
         C := Getch;
      end if;
      C := To_Upper (C);
      Setcursortype (None);
      Gotoxy (11, 24);
      Cputs("                           ");
      return C;
   end Get_Guess;

   function Ask_Next return Boolean is
      C      : Character;
      Result : Boolean := False;
   begin
      Textcolor (White);
      Setcursortype (Solid);
      while C /= 'Y' and C /= 'N' loop
         Gotoxy (32, 24);
         Cputs ("Try again ? (Y/N): ");
         C := Getch;
         if C = K_NUL then
            C := Getch;
         end if;
         C := To_Upper (C);
      end loop;
      Setcursortype (None);
      if C = 'Y' then
         Result := True;
      end if;
      return Result;
   end Ask_Next;

end Input;
