; CONFISET
; Used to export DR-DOS 6.0 config.sys environment variables to a file.

; This assembler part defines the device driver structure, and calls the C
; routine that does the "real work".

; The device never installs.

		ideal	; Borland TASM ideal mode. Better than MASM quirky mode

; Some ASCII values
CR		=	0Dh
LF		=	0Ah
EOF		=	1Ah

; external, the routine written in C
extrn		_initialise:near

; publics, routines or variables used by the C part
public		_isdrdos
public		_getcenv
public		_errno
public		_endofprog

; Pointers to the device command structure
COMMANDCODE	equ	byte ptr si + 02h
DEVSTATUS	equ	word ptr si + 03h

; Device status return bytes.
DEVILLCMD	=	8083h
DEVDONE		=	0080h

; DR-DOS specific constants
CHECKDRDOS	=	4452h
GETINTSTRUC	=	4458h
ENVSEG		equ	word ptr es:bx + 12h

segment		_TEXT	byte public 'CODE'	; Define code segment
		assume	cs:_TEXT,ds:_TEXT

proc		confp	near

; Standard device driver header
		dd	-1		; Next driver link
		dw	08000h		; Attributes word. Standard char device
		dw	strategy	; pointer to strategy routine
		dw	interrupt	; pointer to interrupt routine
		db	'CONFI$ET'	; name.

label		infoblock	dword	; Used to store ES:BX

copyleft	db	CR, '(C) JohnPC 1992. Freely distributable DR-DOS config.sys environment exporter.'
		db	CR, LF, EOF

strategy:	mov	[word ptr cs:infoblock],bx	; Save ES:BX
		mov	[word ptr cs:infoblock + 2],es
		retf

interrupt:	pushf				; Save registers
		push	ax
		push	bx
		push	cx
		push	dx
		push	si
		push	di
		push	ds
		push	es
		lds	si,[cs:infoblock]	; get device call params
		mov	al,[COMMANDCODE]	; get command code
		or	al,al
		jne	illcommand		; if not initialize, error
		push	ds			; push parameter for C routine
		push	si
		push	cs			; set DS
		pop	ds
		call	_initialise		; call C routine
		add	sp,4			; cleanup stack
		lds	si,[cs:infoblock]
		mov	[DEVSTATUS],DEVDONE	; report success
		jmp short enddevint
illcommand:	mov	[DEVSTATUS],DEVILLCMD	; This is very unlikely
enddevint:	pop	es			; restore registers
		pop	ds
		pop	di
		pop	si
		pop	dx
		pop	cx
		pop	bx
		pop	ax
		popf
		retf

endp		confp

; Test for DR DOS. Returns -1 if DR DOS, 0 if not DR DOS
proc		_isdrdos	near

		mov	ax,CHECKDRDOS
		stc
		int	21h
		sbb	ax,ax
		not	ax
		ret

endp		_isdrdos

; Get the config environment. Returns a pointer in DX:AX
proc		_getcenv	near

		push	es
		mov	ax,GETINTSTRUC		; Get internal structure
		int	21h
		mov	dx,[ENVSEG]		; Get segment of environment
		xor	ax,ax
		mov	[ENVSEG],ax		; Clear environment segment
		pop	es
		ret

endp		_getcenv
ends		_TEXT

segment		_DATA	para public 'DATA'	; Define data segment
_errno		dw	0			; Necessary for C routine
ends		_DATA

segment		_BSS	para public 'BSS'	; Define BSS segment
ends		_BSS

segment		_BSSEND byte public 'BSS'	; Last seg, for free pointer
label		_endofprog	byte		; Pointer to end of code
ends		_BSSEND

group		DGROUP		_TEXT,_DATA,_BSS,_BSSEND

end

; EOF confiset.asm