{
                                 

  SMALL.CH  include module for CHESS.PAS
  Last modified:  10/29/85

  This module implements many of the user commands from the
  main menu:  Move, Hint, etc.

                                 
}
var
  Temp,Temp2  : integer;     { Temporary junk }
  TempColor   : ColorType;

const
  LoseValue = $7D00;             { Evaluation constants }
  MateValue = $7C80;
  DepthFactor = $80;

type
  NodeVal = record
              NodeBase,
              NodeOffset : integer;
            end;

var   ProgramColor :   ColorType;     { Color of program }
      MaxDepth :       integer;       { Search Depth counter }
      LegalMoves :     integer;       { Number of Legal moves }
      MoveNo :         integer;       { Move Number }
      UseLib :         integer;       { program uses library if
                                        MoveNo < UseLib }
      MultiMove,                      { Multi Move mode }
      AutoPlay,                       { program plays by itself }
      SingleStep :     boolean;       { SingleStep Search
                                        (used for debuging) }
      MainLine :       LineType;      { Principal variation }
      MainEvalu :      MaxType;       { Evaluation for
                                        principal variation }
      Nodes :          NodeVal;       { Number of analysed Nodes }
      Clock :          ClockType;     { Time used for Analysis }

      OutputFile :     Text;
      PlayerMove :     MoveType;

      { The two chess clocks. Running indicates
        that the Clock for RunColor is Running }
      ChessTime :      array[ColorType] of ClockType;
      Running :        boolean;
      RunColor :       ColorType;

procedure InitChessTime;
{ Initializes the chess clocks }
begin
   InitTime(ChessTime[White]);
   InitTime(ChessTime[Black]);
   Running := False;
end; { InitChessTime }

procedure StopChessTime;
{ Stop the Running chess Clock }
begin
   if Running then
   begin
     StopTime(ChessTime[RunColor]);
     PrintTime(RunColor,ChessTime[RunColor].TotalTime);
   end;
   Running := False;
end; { StopChessTime }

procedure StartChessTime(Color : ColorType);
{ Stop the Running chess Clock and Start the Clock for Color }
begin
  StopChessTime;
  RunColor := Color;
  Running := true;
  StartTime(ChessTime[RunColor]);
end; { StartChessTime }

function IllegalMove(Move : MoveType) : boolean;
{ Tests whether the Move is Legal for
  ProgramColor = Player in the position }
begin
  Perform(Move,False);
  IllegalMove := Attacks(Opponent,PieceTab[Player,0].ISquare);
  Perform(Move,true);
end; { IllegalMove }

procedure MakeMove(Move : MoveType);
{ Makes Move for ProgramColor=Player, and updates variables }
begin
  Depth := Succ(Depth);
  MoveNo := Succ(MoveNo);
  Perform(Move,False);
  ProgramColor := Opponent;
  Opponent := Player;
  Player := ProgramColor;
end; { MakeMove }

procedure TakeBackMove(Move : MoveType);
{ Takes Back Move and updates variables }
begin
   ProgramColor := Opponent;
   Opponent := Player;   Player := ProgramColor;
   Perform(Move,true);
   MoveNo := Pred(MoveNo);
   Depth := Pred(Depth);
end; { TakeBackMove }

procedure ResetMoves;
{ Resets MovTab }
begin
   Depth := -1;
   MovTab[-1] := ZeroMove;
end; { ResetMoves }

procedure AdjustMoves;
{ Moves MovTab to Depth=-1 }
var   i :     integer;
begin
   for i := Depth downto Back do
      MovTab[i - Succ(Depth)] := MovTab[i];
   Depth := -1;
end; { AdjustMoves }

procedure StoreMoves;
{ Moves MovTab One Move Back }
var   i : integer;
begin
   Depth := Pred(Depth);
   for i := Back to Depth do
      MovTab[i] := MovTab[Succ(i)];
   MovTab[Back] := ZeroMove;
end; { StoreMoves }

var   HintLine :  LineType;   { Suggested Hint Line }
      HintEvalu : MaxType;    { Evaluation for HINTLINT }

procedure ClearHint;
{ Clears HintLine }
begin
   HintLine[0] := ZeroMove;
   HintEvalu := 0;
end; { ClearHint }

procedure PrintComment;
{ Prints comment to the game (Check, Mate, Draw, Resign) }
var   Check,PossibleMove,CheckMate : boolean;
      NumMoves : integer;
begin
   Message('');
   CheckMate := False;
   Depth := Succ(Depth);       { Test if there is a Possible Move }
   PossibleMove := False;
   InitMovGen;
   repeat
      MovGen;
      if Next.MovPiece <> Empty then
         if not IllegalMove(Next) then
            PossibleMove := true;
   until (Next.MovPiece = Empty) or PossibleMove;
   Depth := Pred(Depth);
   Check := Attacks(Opponent,PieceTab[Player,0].ISquare); { Calculate Check }
   { No Possible Move means CheckMate or Stalemate }
   if not PossibleMove then
      if Check then
      begin
         CheckMate := true;
         Write('CheckMate!');
      end
      else
         Write('Stalemate!')
   else
     if HintEvalu >= MateValue - DepthFactor * 16 then
     begin
      NumMoves := (MateValue - HintEvalu + $40) div (DepthFactor * 2);
      Write('Mate in ',NumMoves : 1,' Move');
      if NumMoves = 1 then
        Write('!')
      else
        Write('s!');
     end;
   if Check and not CheckMate then
      Write('Check!')
   else         { Test 50 Move rule and Repetition of moves }
     if FiftyMoveCnt >= 100 then Write('50 Move rule')
     else
       if Repetition(False) >= 3 then
          Write('3 fold Repetition')
       else                     { Resign if the position is hopeless }
         if (-25500 < HintEvalu) and (HintEvalu <- $880) then
         case Opponent of
           White : Write('  White resigns');
           Black : Write('  Black resigns');
         end;
   ClearEOL;
end; { PrintComment }

procedure PrintHint(var HintLine : LineType);
{ Prints HintLine On the Screen }
var
  Dep : DepthType;
begin
   Dep := 0;
   while HintLine[Dep].MovPiece <> Empty do begin
      MakeMove(HintLine[Dep]);
      PrintBoard;
      Delay(700);
      Dep := Succ(Dep);
   end;
   while Dep > 0 do
   begin
      Dep := Pred(Dep);
      TakeBackMove(HintLine[Dep]);
   end;
   PrintBoard;
end; { PrintHint }

procedure FlashMove(Move : MoveType);
{ Flashes a Move once On the Screen }
begin
   MakeMove(Move);
   PrintBoard;
   Delay(350);
   TakeBackMove(Move);
   PrintBoard;
   Delay(350);
end; { FlashMove }

procedure EnterMove(Move : MoveType);
{ Performs a Move in the game }
begin
   PrintMove(MoveNo,ProgramColor,Move);
   MakeMove(Move);
   PrintBoard;
   PrintComment;
   StartChessTime(ProgramColor);
end;

var   KeyMove : MoveType;
procedure EnterKeyMove;
{ Perform the Move entered from the keyboard (KeyMove) }
begin
   MovTab[Succ(Depth)] := KeyMove;
   PlayerMove := KeyMove;
   ClearHint;
   EnterMove(MovTab[Succ(Depth)]);
end;

var   Analysis :   boolean;
      OpAn :       boolean;
      WantedTime : real;

procedure StartAnalysis;
{ Calculate the WANTED response Time }
var   TimeControl : integer;
begin
   Ask('');
   Analysis := true;
   OpAn := False;
   case Level of
     Normal :     begin
                    { Divides the Time Left till Next Time Control
                      between the moves Left. There is a margin of
                      4 moves to make sure that the program does
                      not lose On Time }

                    TimeControl := ((MoveNo shr 1 + 20) div 20) * 20;
                    if TimeControl <= 40 then TimeControl := 40;
                    WantedTime := (AverageTime * TimeControl -
                                 ChessTime[ProgramColor].TotalTime) /
                                (TimeControl + 4 - MoveNo shr 1);

                    { in the begining of the game the program thinks
                      around twice as Long, since the early middle
                      game is normally the most crusial part of
                      a game }

                    if MoveNo shr 1 <= 40 then
                       WantedTime := 5.0 + (WantedTime - 5.0) *
                                       ((80 - MoveNo shr 1) / 40);
                 end;
   FullGameTime : begin
                    { Assumes that the game will Last for around 40
                      moves and divides the Time Left accordingly }

                    WantedTime := (AverageTime * 60.0 -
                                 ChessTime[ProgramColor].TotalTime) / 44;

                    { in the begining of the game the program thinks
                      around twice as Long, since the early middle
                      game is normally the most crucial part of
                      a game }
                    if MoveNo shr 1 <= 40 then
                       WantedTime := 5.0 + (WantedTime - 5.0) *
                                       ((80 - MoveNo shr 1) / 40);
                 end;
   DemoGame :     begin
                    { Spends as much Time as the Opponent does }
                    if MoveNo >= 2 then
                       WantedTime := ChessTime[Opponent].TotalTime /
                                   (MoveNo shr 1)
                    else
                       WantedTime := 5.0;
                    WantedTime := WantedTime +
                       (ChessTime[Opponent].TotalTime -
                        ChessTime[ProgramColor].TotalTime) * 0.25;
                 end;
     else WantedTime := 1000000.0;
   end { case };
end; { StartAnalysis }

procedure MoveCheck;
{ This procedure checks to see if the input Move is Legal }
var   InNew,InOld : EdgeSquareType;
      InPiece,PieceCount : PieceType;
begin
   InNew := -1;            { Test if the Command is a Move }
   InOld := -1;
   InPiece := Empty;
   if Length(Command) = 4 then begin    { Two squares (e2e4) }
      InOld := CalcSquare(Command[1],Command[2]);
      InNew := CalcSquare(Command[3],Command[4]);
   end
   else
   if Length(Command) = 3 then           { Piece and Square (Pe4) }
   begin
      InNew := CalcSquare(Command[2],Command[3]);
      for PieceCount := King to Pawn do
         if Command[1] = PieceLetter[PieceCount] then
            InPiece := PieceCount;
   end
   else
   if Length(Command) = 2 then        { One Square Pawn Move (e4) }
   begin
      InNew := CalcSquare(Command[1],Command[2]);
      InPiece := Pawn;
   end;
   if (InNew < 0) or (InOld < 0) and (InPiece = Empty) then Exit;
   Depth := Succ(Depth);                    { Check and Perform Move }
   KeyMove := ZeroMove;
   InitMovGen;
   repeat
      { Generate all moves and find One which matches the input }
      MovGen;
      if (Next.MovPiece <> Empty) and
         (Next.New1 = InNew) then
         if Next.MovPiece = InPiece then
            if KeyMove.MovPiece = Empty then
               KeyMove := Next
            else
            begin
               repeat                { More than One Move }
                  Beep;
                  ReadCom('From-Square: ',MainMenu);
                  if Length(Command) = 2 then
                     InOld := CalcSquare(Command[1],Command[2]);
               until InOld >= 0;
               if KeyMove.Old <> InOld then
                  KeyMove := ZeroMove;
               if Next.Old = InOld then
                  KeyMove := Next;
            end
         else
           if Next.Old = InOld then
             if KeyMove.MovPiece = Empty then KeyMove := Next
   until Next.MovPiece = Empty;
   if KeyMove.MovPiece = Empty then
   begin
      Error('Impossible move');
      Depth := Pred(Depth);
      Command := '';
      Exit;
   end;
   if IllegalMove(KeyMove) then
   begin
     Error('Illegal move. Check!');
     Depth := Pred(Depth);
     Command := '';
     Exit;
   end;

   { The entered Move has been calculated and checked for
     correctness. It is now placed in KeyMove and passed On
     to either Search or Talk }
   Depth := Pred(Depth);
   Command := 'Move';
end; { MoveCheck }

procedure ClearErrMsgs;
begin
  GoToPos(MessagePos,0,0);
  ClearEOL;
end; {ClearErrMsgs}

procedure SmallTalk;
{ SmallTalk handles a small part of the communication with the user.
  The rest of the communication is handled by Talk.
  SmallTalk performs exactly those jobs which can be handled while
  the program is analysing a position. Thus you can Perform some
  communication with the program in parallel with the Analysis.

  On entry, Command contains the input from the keyboard.
  if SmallTalk can handle the job it does so and returns Command
  Empty.
  Otherwise it simply does nothing and returns Command unchanged.
}

procedure ToggleMsg(var Mode : boolean; s : MaxString);
{ Displays / erases Auto-PLAY and Multi-PLAY messages }
begin
  Mode := not Mode;
  case Mode of
    true   : begin
               GoToPos(PlayerPos, 16, 0);
               Write(s);
             end;
    False  : begin
               GoToPos(PlayerPos, 16, 0);
               TextBackground(MenuPos.Background);
               Write(' ': (Length(s)));
             end;
  end; { case }
end; { ToggleMsg }

begin
  case CurOpt of
    QuitMain : begin
                 QuitProgram;             { Quit the chess program }
               end;
      Multi : begin
              { Toggle the MultiMove mode.  In MultiMove mode, the
                human plays both Black and White. }
                if AutoPlay then
                  ToggleMsg(AutoPlay, 'Auto-Play');   { Multi stops auto }
                ToggleMsg(MultiMove, 'Multi-Play');
                Command := '';
                ClearErrMsgs;
              end;
    Single  : begin
               { Toggle the SingleStep mode.  In SingleStep mode,
                 the computer's searching analysis is displayed
                 Move-by-Move.  It waits for the user to press the <Return>
                 key before analyzing the next level.  SingleStep mode ends
                 when the user types "Q" and <Return> }
                if Analysis and not SingleStep then SingleStepMenu;
                SingleStep := true;
                Command := '';
              end;
     Auto   : begin
                { Change AutoPlay mode.  In AutoPlay mode, the program
                  plays against itself.  When a game is finished it starts
                  a New one.  AutoPlay ends when the user types "A" and
                  < Return > }
                if MultiMove then
                  ToggleMsg(MultiMove, 'Multi-Play');  { auto stops multi }
                ToggleMsg(AutoPlay, 'Auto-Play');
                Command := 'PLAY';
              end;
     Hint   : begin
              { Give the user a Hint }
                if Analysis or (HintLine[0].MovPiece <> Empty) then
                begin
                  if Analysis then
                     PrintHint(MainLine)
                  else
                    PrintHint(HintLine);
                  Command := '';
                  ClearErrMsgs;
                end;
              end;
    Unknown : begin
                if not (Command[1] in ['A'..'Z']) then
                begin
                  Error('Illegal input');
                  Command := '';
                 end
                else
                  if not Analysis then MoveCheck;
              end;
  end;  { case }
  ReturnCursor;
end; { SmallTalk }

procedure InitNode(var Nodes : NodeVal);
begin
  with Nodes do
  begin
    NodeBase := 0;
    NodeOffset := 0;
  end;
end;

procedure IncNode(var Nodes : NodeVal);
begin
  with Nodes do
  begin
    if NodeOffset >= MaxInt then
    begin
      NodeBase := Succ(NodeBase);
      NodeOffset := 0;
    end
    else
      NodeOffset := Succ(NodeOffset);
  end;
end;

procedure PrintNodes(Nodes : NodeVal; Time : real);
{ Prints Number of analysed Nodes }
var
  NodeReal : real;
begin
   GoToPos(NodePos,0,0);
   With Nodes do
   begin
     NodeReal := (NodeBase * 32767) + NodeOffset;
     Write('Nodes:',NodeReal:7:0);
     GoToPos(TimePos, 0, 0);
     if Time <> 0 then
       Write('N/Sec:',NodeReal/Time:7:1);
   end;
end; { PrintNodes }

procedure OutputNode(Nodes : NodeVal);
var
  NodeReal : real;
begin
  with Nodes do
  begin
    NodeReal := (NodeBase * 32767) + NodeOffset;
    Write(OutputFile,NodeReal:7:1);
  end;
end; { OutputNode }