{
                                 

  EVALU.CH  include module for CHESS.PAS
  Last modified:  10/29/85

  This module evaluates the current game positions.

                                 
}

procedure FindMove(MaxLevel : integer);
{ Finds a move in the position.
  On exit :
     MAINLINE contains principal variation.
     MAINEVALU contains evaluation of the line
}

type  FileType  = 0..7;   { file numbers }
      RankType  = 0..7;   { Rank numbers }

const { Evaluation parameters }

      { Value of Pieces used in Evaluation }
      PieceValue : array[Empty..Pawn] of integer =
                     (0, $1000, $900, $4C0, $300, $300, $100);
      Tolerance = 8;   { Tolerance Width }
      { Used to calculate distance to center }
      DistAn : array[0..7] of integer = (3,2,1,0,0,1,2,3);
      { The Value of a Pawn is the sum of Rank and file values.
        The file Value is equal to PawnFileFactor * (Rank Number + 2) }
      PawnRank :
         array[RankType] of integer = (0,0, 0, 2, 4, 8,30,0);
      PassPawnRank :
         array[RankType] of integer = (0,0,10,20,40,60,70,0);
      PawnFileFactor :
         array[FileType] of integer = (0,0,2,5,6,2,0,0);

      { Value of castling (Long..Short) }
      CastValue :      array[CastDirType] of integer = (4,32);
      { Value of exchanging Pieces (not pawns) when ahead }
      ExchangeValue = 32;
      { Pawnstructure values }
      IsolatedPawn  = 20;   { Isolated Pawn.
                              Double isolated Pawn is 3 * 20 }
      DoublePawn    =  8;   { Double Pawn }
      SidePawn      =  6;   { Having a Pawn On the side }
      ChainPawn     =  3;   { Being covered by a Pawn }
      CoverPawn     =  3;   { Covering a Pawn }
      NotMovePawn   =  3;   { Penalty for moving Pawn }

      { Penalty for Bishop blocking d2/e2 Pawn }
      BishopBlockValue   = 20;
      { Bonus for Rook behind passed Pawn }
      RookBehindPassPawn = 16;
      { Values for calculating importance of each Square (AttVal) }
      SquareRankValue : array[RankType] of byte = (0,0,0,0,1,2,4,4);

var   { Value of root position in the Search }
      RootValue : MaxType;

      { Total material and material advantage }
      TotalMaterial,PawnTotalMaterial,Material : integer;
      { Material Level of the game
        (early middlegame = 43 - 32, endgame = 0) }
      MaterialLevel : 0..60;

{ Pawnstructure table.
  One and Dob are SETs of FILEs, and contains
  the FILEs which has One respectively more pawns.
  The table is updated and evaluated at each Ply in the Search.
  FileBitTab is used to lookup a file in a set of FILEs }

type  SetofFile   = byte;
const FileBitTab :
         array[FileType] of SetofFile = (1,2,4,8,$10,$20,$40,$80);

type
  PawnBitType = array[ColorType] of
                        record
                          One,Dob : SetofFile;
                        end;

var   PawnBit : array[-1..MaxPly] of PawnBitType;

function PawnStrVal(Depth : DepthType;   Color : ColorType) : integer;
{ Calculate Value of the Pawn structure in PawnBit[Depth,Color] }

   function Count(b : SetofFile) : integer;
   { Counts the Number of set bits in B }
   var Cnt : 0..8;
   begin
      Cnt := 0;
      while b <> 0 do
      begin
         if odd(b) then Cnt := Succ(Cnt);
         b := b shr 1;
      end;
      Count := Cnt;
   end;

var   Iso : SetofFile;   { Contains FILEs with isolated pawns }
begin
   with PawnBit[Depth,Color] do
   begin
      Iso := One and not ((One shl 1) or (One shr 1));
      PawnStrVal := -(Count(Dob) * DoublePawn +
                    Count(Iso) * IsolatedPawn +
                    Count(Iso and Dob) * IsolatedPawn * 2);
   end;
end;


function PiecePosVal(Piece :  PieceType;
                     Color :  ColorType;
                    Square : SquareType) : integer;
{ Calculates the Value of the Piece On the Square }
begin
   PiecePosVal := PieceValue[Piece] + PVTable[Color,Piece,Square];
end;

var
  Mating : BOOLEAN;   { Mating Evaluation function is used }

procedure CalcPVTable;
{ Calculates Piece-Value table for the static Evaluation function }

type  { Pawn table, containing the squares with a Pawn }
      PawnTabType = array[RankType] of SetofFile;

var   PawnTab :      array[ColorType] of PawnTabType;

      { Bit tables for static Pawn structure Evaluation }
      PawnFileTab,Bit,
      OpPassTab,BehindOpPass,
      LeftSideTab ,RightSideTab ,SideTab,
      LeftChainTab,RightChainTab,ChainTab,
      LeftCoverTab,RightCoverTab : SetofFile;

      { Importance of an attack of the Square }
      AttackValue :  array[ColorType,SquareType] of 0..120;

      { Value of squares controlled from the Square }
      PVControl :
         array[ColorType,Rook..Bishop,SquareType] of 0..250;

      LosingColor : ColorType;   { The Color which is being mated }
      PosVal      : integer;     { The positional Value of Piece }
      AttVal      : integer;     { The attack Value of the sqaure }
      Line        : FileType;    { The file of the Piece }
      Rank,Row    : RankType;    { The Rank and Row of the Piece }
      Dist,                      { Distance to center }
      KingDist    : 0..14;       { Distance to opponents King }
      Cast        : CastType;    { Possible castlings }
      Direct      : BOOLEAN;     { Indicates Direct attack }
      Cnt         : integer;     { Counter for attack values }
      StrVal      : integer;     { Pawnstructure Value }
      Color,
      OppColor    : ColorType;   { Color and opponents Color }
      PieceCount  : PieceType;   { Piece counter }
      Square      : SquareType;  { Square counter }
      Dir         : DirType;     { Direction counter }
      Sq          : EdgeSquareType;   { Square counter }
      Temp,Temp2  : integer;     { Temporary junk }

label 10;
begin
  { Calculate SAMMAT, PAWNSAMMAT and Material }
  Mating := False;
  TotalMaterial := 0;
  PawnTotalMaterial := 0;
  Material := 0;
  for Square := 0 to $77 do
    if (Square and $88) = 0 then
      with Board[Square] do
        if Piece <> Empty then
          if Piece <> King then
          begin
            Temp:=PieceValue[Piece];
            TotalMaterial := TotalMaterial + Temp;
            if Piece = Pawn then
              PawnTotalMaterial := PawnTotalMaterial + PieceValue[Pawn];
            if Color = White then Temp := -Temp;
            Material := Material - Temp;
          end;
  MaterialLevel := Max(0,TotalMaterial - $2000) div $100;
  { set Mating if weakest Player has less that the equivalence of
  two Bishops and the advantage is at least a Rook for a Bishop }
  if Material < 0 then
    LosingColor := White
  else
    LosingColor := Black;
  Mating := ((TotalMaterial - abs(Material)) div 2 <= PieceValue[Bishop] * 2)
            and (abs(Material) >= PieceValue[Rook] - PieceValue[Bishop]);
   { Calculate ATTACKVAL (importance of each Square) }
  for Rank := 0 to 7 do
    for Line := 0 to 7 do
    begin
      Square := Rank shl 4 + Line;
      AttVal := Max(0,8 - 3 *
                 (DistAn[Rank] + DistAn[Line])); { Center importance }
      for Color := White to Black do               { Rank importance }
      begin
        AttackValue[Color,Square] := SquareRankValue[Rank] * 3 *
                                     (MaterialLevel + 8) shr 5 + AttVal;
        Square := Square xor $70;
      end;
    end; { for }
   for Color := White to Black do
   begin
      OppColor := ColorType(1 - ord(Color));
      CalcCastling(OppColor,Cast);
      if not (Short in Cast) and (MaterialLevel > 0) then
         { Importance of the 8 squares around the Opponent's King }
         with PieceTab[OppColor,0] do
            for Dir := 0 to 7 do
            begin
               Sq := ISquare + DirTab[Dir];
               if (Sq and $88) = 0 then
                  AttackValue[Color,Sq] := AttackValue[Color,Sq] +
                                           12 * (MaterialLevel + 8) shr 5;
            end;
   end; { for }

   { Calculate PVControl }
   for Square := $77 downto 0 do
     if (Square and $88) = 0 then
       for Color := White to Black do
         for PieceCount := Rook to Bishop do
            PVControl[Color,PieceCount,Square] := 0;
   for Square := $77 downto 0 do
     if (Square and $88) = 0 then
       for Color := White to Black do
       begin
         for Dir := 7 downto 0 do
         begin
            if Dir < 4 then
               PieceCount := Rook
            else
               PieceCount := Bishop;
            { Count Value of all Attacks from the Square in
              the Direction.
              The Value of attacking a Square is Found in ATTACKVAL.
              Indirect Attacks (e.g. a Rook attacking through
              another Rook) counts for a Normal attack,
              Attacks through another Piece counts half }
            Cnt := 0;
            Sq := Square;
            Direct := true;
            repeat
               { Get Next Square }
               Sq := Sq + DirTab[Dir];
               if (Sq and $88) <> 0 then goto 10;
               Temp:=AttackValue[Color,Sq];
               if Direct then                     { Add AttackValue }
                  Cnt := Cnt + Temp
               else
                  Cnt := Cnt + Temp shr 1;
               with Board[Sq] do
                 if Piece <> Empty then
                   if (Piece <> PieceCount) and (Piece <> Queen) then
                      Direct := False;
            until Board[Sq].Piece = Pawn;
         10 : PVControl[Color,PieceCount,Square] :=
               PVControl[Color,PieceCount,Square] + Cnt shr 2;
         end { for Dir };
      end { for Color };

   { Calculate PVTable, Value by Value }
   for Square := $77 downto 0 do
     if (Square and $88) = 0 then
     begin
       for Color := White to Black do
       begin
         OppColor := ColorType(1 - ord(Color));
         Line := Square and 7;
         Row := Square shr 4;
         Rank := Row;
         if Color = Black then Rank := 7 - Rank;
         Dist := DistAn[Rank] + DistAn[Line];
         with PieceTab[OppColor,0] do
            KingDist := abs(Square shr 4 - ISquare shr 4) +
                      (Square - ISquare) and 7;
         for PieceCount := King to Pawn do
         begin
            PosVal := 0;          { Calculate POSITIONAL Value for }
                                  { the Piece On the Square }
            if Mating and (PieceCount <> Pawn) then
            begin
               if PieceCount = King then               { Mating Evaluation }
                  if Color = LosingColor then
                  begin
                     PosVal := 128 - 16 * DistAn[Rank] - 12 * DistAn[Line];
                     if DistAn[Rank] = 3 then
                        PosVal := PosVal - 16;
                  end
                  else
                  begin
                     PosVal := 128 - 4 * KingDist;
                     if (DistAn[Rank] >= 2) or (DistAn[Line] = 3) then
                        PosVal := PosVal - 16;
                  end;
            end { Mating }
            else
            begin
               Temp := PVControl[Color,Rook,Square];
               Temp2:= PVControl[Color,Bishop,Square];
               { Normal Evaluation function }
               case PieceCount of
                  King :   if MaterialLevel <= 0 then PosVal := -2 * Dist;
                  Queen :  PosVal := (Temp + Temp2) shr 2;
                  Rook :   PosVal := Temp;
                  Bishop : PosVal := Temp2;
                  Knight : begin
                             Cnt := 0;
                             for Dir := 0 to 7 do
                             begin
                                Sq := Square + KnightDir[Dir];
                                if (Sq and $88) = 0 then
                                   Cnt := Cnt + AttackValue[Color,Sq];
                             end;
                             PosVal := Cnt shr 1 - Dist * 3;
                          end;
                  Pawn :   if (Rank <> 0) and (Rank <> 7) then
                             PosVal :=
                                PawnRank[Rank] +
                                PawnFileFactor[Line] * (Rank + 2) - 12;
               end { case };
            end; { else }
            PVTable[Color,PieceCount,Square] := PosVal;
         end { for PieceCount };
       end { for Color };
   end { for Square };

   { Calculate PawnTab (indicates which squares contain pawns) }
   for Color := White to Black do
     for Rank := 0 to 7 do
       PawnTab[Color,Rank] := 0;
   for Square := $77 downto 0 do
     if (Square and $88) = 0 then
       with Board[Square] do
         if Piece = Pawn then
         begin
            Rank := Square shr 4;
            if Color = Black then Rank := 7 - Rank;
            PawnTab[Color,Rank] :=
               PawnTab[Color,Rank] or FileBitTab[Square and 7];
         end; { if }
   for Color := White to Black do   { Initialize PawnBit }
      with PawnBit[-1,Color] do
      begin
         One := 0;
         Dob := 0;
         for Rank := 1 to 6 do
         begin
            Temp := PawnTab[Color,Rank];
            Dob := Dob or One and Temp;
            One := One or Temp;
         end;
      end;
   { Calculate PawnStructureValue }
   RootValue := PawnStrVal(-1,Player) - PawnStrVal(-1,Opponent);

   { Calculate static Value for Pawn structure }
   for Color := White to Black do
   begin
      OppColor := ColorType(1 - ord(Color));
      PawnFileTab := 0;
      LeftSideTab := 0;
      RightSideTab := 0;
      OpPassTab := $FF;
      BehindOpPass := 0;
      for Rank := 1 to 6 do { Squares where opponents pawns are passed pawns }
      begin
         OpPassTab := OpPassTab and not (PawnFileTab or
                             LeftSideTab or RightSideTab);
         { Squares behind the opponents passed pawns }
         BehindOpPass := BehindOpPass or
                        (OpPassTab and PawnTab[OppColor,7 - Rank]);
         { Squares which are covered by a Pawn }
         LeftChainTab := LeftSideTab;
         RightChainTab := RightSideTab;
         PawnFileTab  := PawnTab[Color,Rank];         { Squares with pawns }
         { Squares with a Pawn beside them }
         LeftSideTab  := (PawnFileTab shl 1) and $FF;
         RightSideTab := (PawnFileTab shr 1) and $FF;
         SideTab      := LeftSideTab  or RightSideTab;
         ChainTab     := LeftChainTab or RightChainTab;
         { Squares covering a Pawn }
         Temp := PawnTab[Color,Succ(Rank)];
         LeftCoverTab := (Temp shl 1) and $FF;
         RightCoverTab := (Temp shr 1) and $FF;
         Sq := Rank shl 4;
         if Color = Black then Sq := Sq xor $70;
         Bit := 1;
         while Bit <> 0 do
         begin
            StrVal := 0;
            if (Bit and SideTab) <> 0 then
               StrVal := SidePawn
            else if (Bit and ChainTab) <> 0 then
               StrVal := ChainPawn;
            if (Bit and LeftCoverTab) <> 0 then
               StrVal := StrVal + CoverPawn;
            if (Bit and RightCoverTab) <> 0 then
               StrVal := StrVal + CoverPawn;
            if (Bit and PawnFileTab) <> 0 then
               StrVal := StrVal + NotMovePawn;
            PVTable[Color,Pawn,Sq] := PVTable[Color,Pawn,Sq] + StrVal;
            if (MaterialLevel <= 0) or (OppColor <> ProgramColor) then
            begin
              if (Bit and OpPassTab) <> 0 then                 { Passed pawns }
                 PVTable[OppColor,Pawn,Sq] :=
                    PVTable[OppColor,Pawn,Sq] + PassPawnRank[7 - Rank];
              if (Bit and BehindOpPass) <> 0 then { Rooks behind passed pawns }
              begin
                 Temp := Sq xor $10;
                 for TempColor:=Black to White do
                 begin
                   PVTable[TempColor,Rook,Sq] :=
                      PVTable[TempColor,Rook,Sq] + RookBehindPassPawn;
                   if Rank = 6 then
                     PVTable[TempColor,Rook,Temp] :=
                        PVTable[TempColor,Rook,Temp] + RookBehindPassPawn;
                 end; { for }
              end; { if }
            end; { if }
            Sq := Succ(Sq);
            Bit := (Bit shl 1) and $FF;
         end; { while }
      end; { for }
   end; { for }
   { Calculate penalty for blocking center pawns with a Bishop }
   for Sq := 3 to 4 do
   begin
      with Board[Sq + $10] do
         if (Piece = Pawn) and (Color = White) then
            PVTable[White,Bishop,Sq + $20] :=
               PVTable[White,Bishop,Sq + $20] - BishopBlockValue;
      with Board[Sq + $60] do
         if (Piece = Pawn) and (Color = Black) then
            PVTable[Black,Bishop,Sq + $50] :=
               PVTable[Black,Bishop,Sq + $50] - BishopBlockValue;
   end; { for }
   for Square := $77 downto 0 do         { Calculate RootValue }
     if (Square and $88) = 0 then
       with Board[Square] do
         if Piece <> Empty then
           if Color = Player then
             RootValue :=
                  RootValue + PiecePosVal(Piece,Player,Square)
           else
             RootValue :=
                RootValue - PiecePosVal(Piece,Opponent,Square);
end { CalcPVTable };

function StateValu(Move : MoveType) : integer;
{ Calculates STATIC Evaluation of the Move }
var   Value : integer;
      CastSquare,CornerSquare,EpSquare : SquareType;

   function DecPawnStrVal(Color : ColorType;   Line : FileType) :
               integer;
   { Updates PawnBit and calculates Value when a Pawn is
     removed from Line }
   begin
      with PawnBit[Depth,Color] do
      begin
         Temp := not FileBitTab[Line];
         One := One and Temp or Dob;
         Dob := Dob and Temp;
      end;
      DecPawnStrVal := PawnStrVal(Depth,Color) -
                       PawnStrVal(Pred(Depth),Color);
   end; { DecPawnStrVal }

   function MovePawnStrVal(Color : ColorType;
                       New1, Old : FileType) : integer;
   { Updates PawnBit and calculates Value when a Pawn moves
     from Old to New1 file }
   begin
      with PawnBit[Depth,Color] do
      begin
         Temp := FileBitTab[New1];
         Temp2 := not FileBitTab[Old];
         Dob := Dob or One and Temp;
         One := One and Temp2 or Dob or Temp;
         Dob := Dob and Temp2;
      end; { with }
      MovePawnStrVal := PawnStrVal(Depth  ,Color) -
                      PawnStrVal(Pred(Depth),Color);
   end; { MovePawnStrVal }

begin { StateValu }
   with Move do
   begin
      Value := 0;
      if Spe then
         if MovPiece = King then
         begin
            GenCastSquare(New1,CastSquare,CornerSquare);    { Castling }
            Value := PiecePosVal(Rook,Player,CastSquare) -
                     PiecePosVal(Rook,Player,CornerSquare);
            if New1 > Old then
               Value := Value + CastValue[Short]
            else
               Value := Value + CastValue[Long];
         end
         else
           if MovPiece = Pawn then
           begin
             EpSquare := New1 - PawnDir[Player];         { E.p. capture }
             Value := PiecePosVal(Pawn,Opponent,EpSquare);
           end
           else
             { Pawnpromotion }
             Value := PiecePosVal(MovPiece,Player,Old) -
                   PiecePosVal(Pawn    ,Player,Old) +
                   DecPawnStrVal(Player  ,Old and 7);
      if Content <> Empty then                      { Normal moves }
      begin
         Value := Value + PiecePosVal(Content,Opponent,New1);
         { Penalty for exchanging Pieces when behind in material }
         if abs(MainEvalu) >= $100 then
            if Content <> Pawn then
               if (ProgramColor = Opponent) = (MainEvalu >= 0) then
                  Value := Value - ExchangeValue;
      end; { if }
      PawnBit[Depth] := PawnBit[Pred(Depth)];       { Calculate PawnBit }
      if (MovPiece = Pawn) and ((Content <> Empty) or Spe) then
         Value := Value + MovePawnStrVal(Player,New1 and 7,Old and 7);
      if (Content = Pawn) or Spe and (MovPiece = Pawn) then
         Value := Value - DecPawnStrVal(Opponent,New1 and 7);
      { Calculate Value of Move }
      StateValu := Value + PiecePosVal(MovPiece,Player,New1) -
                       PiecePosVal(MovPiece,Player,Old);
   end; { with }
end; { StateValu }
