%TITLE "Windows application shell in assembly language -- by Tom Swan"

        IDEAL

        JUMPS

        P286

        LOCALS  @@

        MODEL   large, WINDOWS PASCAL

;----- Include Windows declarations (MASM mode required)

        %NOINCL

        MASM

        INCLUDE windows.inc

        IDEAL

;----- Include resource identifiers

        INCLUDE "winapp.ri"

;----- Define external functions imported from Windows

EXTRN   InitTask:PROC
EXTRN   WaitEvent:PROC
EXTRN   InitApp:PROC
EXTRN   LoadIcon:PROC
EXTRN   LoadCursor:PROC
EXTRN   CreateWindow:PROC
EXTRN   ShowWindow:PROC
EXTRN   UpdateWindow:PROC
EXTRN   RegisterClass:PROC
EXTRN   GetMessage:PROC
EXTRN   TranslateMessage:PROC
EXTRN   DispatchMessage:PROC
EXTRN   PostQuitMessage:PROC
EXTRN   DefWindowProc:PROC
EXTRN   SendMessage:PROC
EXTRN   MakeProcInstance:PROC
EXTRN   FreeProcInstance:PROC
EXTRN   DialogBox:PROC
EXTRN   EndDialog:PROC
EXTRN   MessageBox:PROC
EXTRN   DestroyWindow:PROC
EXTRN   BeginPaint:PROC
EXTRN   EndPaint:PROC
EXTRN   Rectangle:PROC

;----- Define global program procedures called internally

GLOBAL  PASCAL  WinMain:PROC
GLOBAL  PASCAL  AppInit:PROC
GLOBAL  PASCAL  AppRun:PROC
GLOBAL  PASCAL  RegisterWin:PROC
GLOBAL  PASCAL  WinAppCommands:PROC
GLOBAL  PASCAL  HelpAbout:PROC

;----- Define program procedures exported to Windows

PUBLIC  WndProc
PUBLIC  DlgProc

;----- Global initialized variables

        DATASEG

;----- The following 16-byte buffer must be first in the program's
;      data segment. Windows uses this area for its own purposes.

                DB   16 DUP (0)         ; Reserved for Windows
exCode          DB   0                  ; Exit code returned to DOS
szAppName       DB   'WinApp', 0        ; App name or window title
szWndName       DB   'WinAppWin', 0     ; Window class name
szDlgString     DB   'End program?', 0  ; Message-box string

;----- Global uninitialized variables

        UDATASEG

psp             DW        ?             ; Program segment prefix
pszCmdLine      DW        ?             ; Pointer to command line string
hPrevInst       DW        ?             ; Handle to previous instance
hInstance       DW        ?             ; Handle to this instance
cmdShow         DW        ?             ; Window display style
msg             MSGSTRUCT ?             ; Message loop structure
ps              PAINTSTRUCT ?           ; WM_PAINT structure 

        CODESEG

Start:  

;----- Begin required initializations

        call    InitTask                ; Initialize this task
        or      ax, ax                  ; Test result in ax
        jnz     @@InitTaskOk            ; Continue if ax is not zero
        jmp     @@InitFail              ; Else exit with error code

@@InitTaskOk:

;----- Save various items returned by InitTask

        mov     [psp], es               ; Program segment prefix
        mov     [pszCmdLine], bx        ; Pointer to command line (es:bx)
        mov     [hPrevInst], si         ; Previous program instance handle
        mov     [hInstance], di         ; This program instance handle
        mov     [cmdShow], dx           ; Window display style

;----- Continue required initializations

        push    0                       ; Push task ID (0 = current task)
        call    WaitEvent               ; Clear any waiting events
        push    di                      ; Push program instance handle
        call    InitApp                 ; Initialize application queue
        or      ax, ax                  ; Test result in ax
        jnz     @@InitAppOk             ; Continue if InitApp successful
        jmp     @@InitFail              ; Else exit with error code

@@InitAppOk:

        call    WinMain                 ; Inits done--start application
        jmp     Exit                    ; Jump to exit

@@InitFail:

        mov     [exCode], 0ffh          ; Startup error code = -1

Exit:   mov     ah, 04Ch                ; DOS function: Exit program
        mov     al, [exCode]            ; Return exit code value
        int     21h                     ; Call DOS.  Terminate program
%NEWPAGE
;---------------------------------------------------------------
; WinMain               Equivalent to WinMain in a C program
;---------------------------------------------------------------
; Input:
;   none
;   Note:   This procedure isn't required, but it permits Turbo
;           Debugger to skip over the startup code and begin
;           tracing here. Apparently, this happens because TD
;           recognizes WinMain as the application entry point.
; Output:
;   none
; Registers:
;   none
;---------------------------------------------------------------
PROC    WinMain PASCAL
        call    AppInit                 ; Initialize application
        call    AppRun                  ; Execute message loop
        ret
ENDP    WinMain
%NEWPAGE
;---------------------------------------------------------------
; AppInit               Register and create the app's window
;---------------------------------------------------------------
; Input:
;   hPrevInst   Handle to previous instance (global)
;   hInstance   Handle to this instance (global)
;   cmdShow     Window display style (global)
; Output:
;   none
; Registers:
;   ax
;---------------------------------------------------------------
PROC    AppInit PASCAL
        USES    di, si

        call    RegisterWin             ; Register program's main window
        mov     si, [hInstance]         ; Use si to hold instance handle

;----- Create element of window from registered window class

        push    ds                      ; Segment for szWndName
        push    OFFSET szWndName        ; The window's class name
        push    ds                      ; Segment for szAppName
        push    OFFSET szAppName        ; Caption for title bar
        push    WS_OVERLAPPEDWINDOW     ; The window's style
        push    0                       ; Low word of Style
        push    CW_USEDEFAULT           ; Starting x coordinate
        push    CW_USEDEFAULT           ; Starting y coordinate
        push    CW_USEDEFAULT           ; Starting width
        push    CW_USEDEFAULT           ; Starting height
        push    0                       ; Handle to parent window (none)
        push    0                       ; Handle to menu (none)
        push    si                      ; Program instance handle
        push    0                       ; Optional user parameters (none)
        push    0                       ; Optional user parameters (none)
        call    CreateWindow            ; Create window element
        mov     di, ax                  ; Save window handle in di

;----- Begin process of showing main window

        push    di                      ; Push window handle
        push    [cmdShow]               ; Push window style
        call    ShowWindow              ; Make window visible

;----- Force immediate painting of window contents

        push    di                      ; Push window handle
        call    UpdateWindow            ; Update window contents

        ret
ENDP    AppInit
%NEWPAGE
;---------------------------------------------------------------
; AppRun                Run the application (the "message loop")
;---------------------------------------------------------------
; Input:
;   none
; Output:
;   none
; Registers:
;   ax
;---------------------------------------------------------------
PROC    AppRun  PASCAL
@@10:   push    ds                      ; Push msg segment address
        push    OFFSET msg              ; Push msg offset address
        push    NULL                    ; Unused
        push    NULL                    ; Unused
        push    NULL                    ; Unused
        call    GetMessage              ; Get next message
        or      ax, ax                  ; Did GetMessage return zero?
        jz      @@99                    ; If yes, exit loop
        push    ds                      ; Push msg segment address
        push    OFFSET msg              ; Push msg offset address
        call    TranslateMessage        ; Translate keyboard messages
        push    ds                      ; Push msg segment address
        push    OFFSET msg              ; Push msg offset address
        call    DispatchMessage         ; Send message to window proc
        jmp     @@10                    ; Loop until app ends
@@99:   ret
ENDP    AppRun
%NEWPAGE
;---------------------------------------------------------------
; RegisterWin        Register the program's main window class
;---------------------------------------------------------------
; Input:
;   hPrevInst   Handle to previous instance (global)
;   hInstance   Handle to this instance (global)
; Output:
;   none
; Registers:
;   ax
;---------------------------------------------------------------
PROC    RegisterWin  PASCAL
        LOCAL   @@wc:WNDCLASS           ; Allocate structure on stack
        USES    di, si                  ; Preserve registers

        cmp     [hPrevInst], 0          ; Is a prior instance running?
        jne     @@99                    ; If yes, jump to exit
        mov     si, [hInstance]         ; Use si to hold instance handle

;----- Assign values to global window class structure @@wc

        mov     [@@wc.clsStyle], NULL
        mov     [WORD PTR @@wc.clsLpfnWndProc      ], OFFSET WndProc
        mov     [WORD PTR (@@wc.clsLpfnWndProc) + 2], SEG WndProc
        mov     [@@wc.clsCbClsExtra], 0
        mov     [@@wc.clsCbWndExtra], 0
        mov     [@@wc.clsHInstance], si

;----- Get and assign icon handle from app's resources

        push    si                      ; Program instance handle
        push    0                       ; High word of resource ID
        push    ID_ICON                 ; Low word of resource ID
        call    LoadIcon                ; Load icon from app's resources
        mov     [@@wc.clsHIcon], ax     ; Save resulting icon handle

;----- Get and assign a cursor handle

        push    0                       ; Instance handle (none)
        push    0                       ; High word of resource ID
        push    IDC_ARROW               ; Low word of resource ID
        call    LoadCursor              ; Load standard cursor
        mov     [@@wc.clsHCursor], ax   ; Save resulting cursor handle

;----- Assign remaining window class structure values

        mov     [@@wc.clsHbrBackground], COLOR_WINDOW + 1
        mov     [WORD PTR @@wc.clsLpszMenuName       ], ID_MENU
        mov     [WORD PTR (@@wc.clsLpszMenuName) + 2 ], 0
        mov     [WORD PTR @@wc.clsLpszClassName      ], OFFSET szWndName
        mov     [WORD PTR (@@wc.clsLpszClassName) + 2], ds

;----- Register the window class 

        push    ss                      ; Push segment of wc
        lea     ax, [@@wc]              ; Load ax with wc offset
        push    ax                      ; Push offset of wc
        call    RegisterClass           ; Register the window class
@@99:
        ret
ENDP    RegisterWin
%NEWPAGE
;---------------------------------------------------------------
; WndProc               Main Window Procedure (called by Windows)
;---------------------------------------------------------------
; Input:
;   hWnd        WORD (stack)    Handle to window
;   uMsg        WORD (stack)    Message identifier
;   wp          WORD (stack)    Optional word parameter
;   lp          DWORD (stack)   Optional double word parameter
; Output:
;   Depends on message
; Registers:
;   ax, dx  
;---------------------------------------------------------------
PROC    WndProc WINDOWS PASCAL FAR
        ARG     hWnd:WORD, uMsg:WORD, wp:WORD, lp:DWORD
        USES    di, si

        mov     di, [hWnd]              ; Use di to hold window handle
        mov     si, [uMsg]              ; Use si to hold message
        cmp     si, WM_DESTROY          ; Is message WM_DESTROY?
        je      @@WMDESTROY             ; If yes, jump to process message
        cmp     si, WM_CLOSE            ; Is message WM_CLOSE?
        je      @@WMCLOSE               ; If yes, jump to process message
        cmp     si, WM_PAINT            ; Is message WM_PAINT?
        je      @@WMPAINT               ; If yes, jump to process message
        cmp     si, WM_COMMAND          ; Is message WM_COMMAND?
        je      @@WMCOMMAND             ; If yes, jump to process message
        jmp     @@DEFWINDOWPROC         ; Else jump to default processor

;----- Process WM_DESTROY message

@@WMDESTROY:
        push    0                       ; Push user-defined exit code
        call    PostQuitMessage         ; Call Windows to post WM_QUIT msg
        jmp     @@RETURNZERO            ; Return 0L (long 32-bit zero)

;----- Process WM_CLOSE message

@@WMCLOSE:
        push    di                      ; Push window handle
        push    ds                      ; Push segment of dialog string
        push    OFFSET szDlgString      ; Push offset of dialog string
        push    ds                      ; Push segment of title string
        push    OFFSET szAppName        ; Push offset of title string
        push    MB_ICONQUESTION OR MB_YESNO  ; Push message-box styles
        call    MessageBox              ; Call Windows function
        cmp     ax, IDYES               ; Did user select Yes button?
        jne     @@RETURNZERO            ; If no, exit WM_CLOSE processor
        push    di                      ; Else push window handle
        call    DestroyWindow           ; Destroy window and end program
        jmp     @@RETURNZERO            ; Return 0L (long 32-bit zero)

@@WMPAINT:
        push    di                      ; Push window handle
        push    ds                      ; Push segment of ps structure
        push    OFFSET ps               ; Push offset of ps structure
        call    BeginPaint              ; Initiate GDI painting
        mov     si, ax                  ; Save device context handle in si

;----- Call a GDI function

        push    si                      ; Push HDC
        push    10                      ; Push rectangle coordinates
        push    25
        push    200
        push    150
        call    Rectangle               ; Draw the rectangle

;----- Insert other GDI function calls here

        push    di                      ; Push window handle
        push    ds                      ; Push segment of ps structure
        push    OFFSET ps               ; Push offset of ps structure
        call    EndPaint                ; End GDI painting
        jmp     @@RETURNZERO            ; Return 0L (long 32-bit zero)

;----- Process WM_COMMAND message

@@WMCOMMAND:
        push    di                      ; Push window handle
        push    [wp]                    ; Push word parameter
        push    [lp]                    ; Push long parameter
        call    WinAppCommands          ; Call our command handler
        jmp     @@RETURNZERO            ; Return 0L (long 32-bit zero)

;----- Call Windows default message handler

@@DEFWINDOWPROC:
        push    di                      ; Push window handle
        push    si                      ; Push message value
        push    [wp]                    ; Push optional word parameter
        push    [lp]                    ; Push optional long parameter
        call    DefWindowProc           ; Call default message handler
        jmp     @@99                    ; Return DefWindowProc result

@@RETURNZERO:
        xor     ax, ax                  ; Return 0L (DWORD zero) in ax:dx
        xor     dx, dx
@@99:  
        ret
ENDP    WndProc
%NEWPAGE
;---------------------------------------------------------------
; DlgProc               Dialog procedure (called by Windows)
;---------------------------------------------------------------
; Input:
;   hWndDlg     WORD (stack)    Handle to dialog window
;   uMsg        WORD (stack)    Message identifier
;   wp          WORD (stack)    WM_COMMAND identifier
;   lp          DWORD (stack)   Optional double word parameter
; Output:
;   Depends on message
; Registers:
;   ax
;---------------------------------------------------------------
PROC    DlgProc WINDOWS PASCAL FAR
        ARG     hWndDlg:WORD, uMsg:WORD, wp:WORD, lp:DWORD
        USES    si

        mov     si, [uMsg]              ; Use si to hold message
        cmp     si, WM_INITDIALOG       ; Is it WM_INITDIALOG?
        je      @@WMINITDIALOG          ; If yes, jump to process messasge
        cmp     si, WM_COMMAND          ; Is it WM_COMMAND?
        je      @@WMCOMMAND             ; If yes, jump to process message
        jmp     @@RETURNFALSE           ; Other messages--exit

;----- Process WM_INITDIALOG message

@@WMINITDIALOG:                         ; Insert any initializations here
        jmp     @@RETURNTRUE            ; Exit and return TRUE

;----- Process WM_COMMAND message (for dialog buttons, etc.)

@@WMCOMMAND:
        mov     si, [wp]                ; Use si to hold WM_COMMAND id
        cmp     si, IDOK                ; Is it IDOK?
        je      @@IDOK                  ; If yes, jump to process command
        jmp     @@RETURNFALSE           ; Else exit and return FALSE

;----- Process IDOK command (e.g. when user selects the OK button)

@@IDOK:
        push    [hWndDlg]               ; Push dialog window handle
        push    0                       ; Push value to return to caller
        call    EndDialog               ; End the dialog
;        jmp     @@RETURNTRUE           ; Enable to add more commands

@@RETURNTRUE:
        mov     ax, TRUE                ; Return BOOL true value
        jmp     @@99

@@RETURNFALSE:
        mov     ax, FALSE               ; Return BOOL false value
@@99:   ret
ENDP    DlgProc
%NEWPAGE
;---------------------------------------------------------------
; WinAppCommands        Menu command subroutine
;---------------------------------------------------------------
; Input:
;   hWnd        WORD (stack)    Handle to window
;   wp          WORD (stack)    Word parameter (command ID)
;   lp          DWORD (stack)   Optional double word parameter
; Output:
;   none
; Registers:
;   none
;---------------------------------------------------------------
PROC    WinAppCommands PASCAL
        ARG     hWnd:WORD, wId:WORD, lp:DWORD
        USES    di, si

        mov     di, [hWnd]              ; Move window handle into di
        mov     si, [wId]               ; Move command ID into si
        cmp     si, CM_DEMO_EXIT        ; Is command CM_DEMO_EXIT?
        je      @@CMDEMOEXIT            ; If yes, jump to process
        cmp     si, CM_HELP_ABOUT       ; Is command CM_HELP_ABOUT?
        je      @@CMHELPABOUT           ; If yes, jump to process
        jmp     @@99                    ; Unrecognized command -- exit

;----- Process the menu's Demo:Exit command

@@CMDEMOEXIT:
        push    di                      ; Push window handle
        push    WM_CLOSE                ; Push message to send
        push    0                       ; Push unused word parameter
        push    0                       ; Push unused long parameter (1)
        push    0                       ; Push unused long parameter (2)
        call    SendMessage             ; Send WM_CLOSE message
        jmp     @@99

;----- Process the menu's Help:About command

@@CMHELPABOUT:
        push    di                      ; Push window handle
        call    HelpAbout               ; Call our about-box subroutine
;        jmp     @@99                   ; Enable to add more commands

@@99:   ret
ENDP    WinAppCommands
%NEWPAGE
;---------------------------------------------------------------
; HelpAbout             About box subroutine
;---------------------------------------------------------------
; Input:
;   hWnd        WORD (stack)    Handle to dialog-owner window
; Output:
;   none
; Registers:
;   none
;---------------------------------------------------------------
PROC    HelpAbout PASCAL
        ARG     hWnd:WORD
        USES    di, si

        push    SEG DlgProc             ; Push dialog procedure segment
        push    OFFSET DlgProc          ; Push dialog procedure offset
        push    [hInstance]             ; Push program instance handle
        call    MakeProcInstance        ; Make procedure instance
        mov     di, dx                  ; Save segment address in di
        mov     si, ax                  ; Save offset address in si

        push    [hInstance]             ; Push program instance handle
        push    0                       ; Push segment value (0 = flag)
        push    ID_ABOUT                ; Push dialog box resource ID
        push    [hWnd]                  ; Push owning window handle
        push    di                      ; Push procedure instance segment
        push    si                      ; Push procedure instance offset
        call    DialogBox               ; Execute dialog box

        push    di                      ; Push procedure instance segment
        push    si                      ; Push procedure instance offset
        call    FreeProcInstance        ; Free procedure instance

        ret
ENDP    HelpAbout

        END     Start           ; End of program / entry point
