/* Inline Assembly Language Function Demonstration */

#pragma inline

#include <stdio.h>
#include <string.h>

extern void BumpStrUp(unsigned char far * TheString,
  int StringLength);

extern void BumpStrDown(unsigned char far * TheString,
  int StringLength);

char *MixedUp = "UppER aNd LOwEr CaSE";

int main()
{
  printf("Before BumpStrUp:  %s\n", MixedUp);
  BumpStrUp( MixedUp, strlen(MixedUp) );
  printf("After BumpStrUp:   %s\n", MixedUp);
  BumpStrDown( MixedUp, strlen(MixedUp) );
  printf("After BumpStrDown: %s\n", MixedUp);
  return 0;
}

void BumpStrUp(unsigned char far * TheString,
  int StringLength)
{
  asm les di, TheString           /* Address string with es:di */
  asm mov cx, StringLength        /* Load string length into cx */
  asm jcxz Exit                   /* Exit if length = 0 */
  asm cld                         /* Auto-increment di */
NextChar:
  asm mov al, es:[Byte ptr di]    /* Load next character */
  asm cmp al, 'a'                 /* Skip conversion if */
  asm jb NotLower                 /*  character is not */
  asm cmp al, 'z'                 /*  lowercase */
  asm ja NotLower
  asm sub al, 32                  /* Convert to uppercase */
NotLower:
  asm stosb                       /* Store character in string */
  asm loop NextChar               /* Loop until done */
Exit:;
}

void BumpStrDown( unsigned char far * TheString,
  int StringLength )
{
  asm les di, TheString           /* Address string with es:di */
  asm mov cx, StringLength        /* Load string length into cx */
  asm jcxz Exit                   /* Exit if length = 0 */
    asm cld                         /* Auto-increment di */
NextChar:
  asm mov al, es:[Byte ptr di]    /* Load next character */
  asm cmp al, 'A'                 /* Skip conversion if */
  asm jb NotUpper                 /*  character is not */
  asm cmp al, 'Z'                 /*  uppercase */
  asm ja NotUpper
  asm add al, 32                  /* Convert to lowercase */
NotUpper:
  asm stosb                       /* Store character in string */
  asm loop NextChar               /* Loop until done */
Exit:;
}
