%TITLE "Terminal Emulator -- Copyright (c) 1989,1995 by Tom Swan"

        IDEAL

        MODEL   small
        STACK   1024

;-----  From ASYNCH.OBJ
        EXTRN   ComPort:abs

cr              EQU     13      ; ASCII carriage return
lf              EQU     10      ; ASCII line feed
bd9600          EQU     0e3h    ; 9600 baud, no parity, 1 stop, 8 bits
ExitKey         EQU     100     ; GetCh value for F10


        DATASEG

exCode          DB      0

welcome         DB      cr, lf, 'Terminal Emulator by Tom Swan', cr, lf
                DB      cr, lf, 'Configured for 9600 baud.  Displays'
                DB      cr, lf, 'control codes in brackets for debugging'
                DB      cr, lf, 'an RS232 serial line.  Press F10'
                DB      cr, lf, 'to exit.', cr, lf, lf, 0

string          DB      80 DUP (?)      ; Miscellaneous string


        CODESEG

;-----  From ASYNCH.OBJ
        EXTRN   AsynchInit:proc, AsynchStop:proc, AsynchStat:proc
        EXTRN   AsynchOut:proc, AsynchIn:proc, AsynchInStat:proc

;-----  From KEYBOARD.OBJ
        EXTRN   KeyWaiting:proc, GetCh:proc

;-----  From BINASC.OBJ
        EXTRN   BinToAscDec:proc

;-----  From STRIO.OBJ
        EXTRN   StrWrite:proc

Start:  
        mov     ax, @data               ; Initialize DS to address
        mov     ds, ax                  ;  of data segment
        mov     es, ax                  ; Make es = ds

        mov     di, offset welcome      ; Display welcoming message
        call    StrWrite

;-----  Initialize baud rate and Asynch package

        mov     ah, 0                   ; BIOS RS232 init function
        mov     al, bd9600              ; configuration
        mov     dx, ComPort             ; Port number (0 or 1)
        int     14h                     ; Call RS232_IO service
        call    AsynchInit              ; Initialize asynch package

;-----  Perform terminal I/O emulation

Emulate:
        call    AsynchInStat            ; Any chars come in yet?
        or      dx, dx                  ; Check if dx > 0
        jz      @@10                    ; dx=0, check for keypress
        call    AsynchIn                ; Read char from buffer
        call    DispChar                ; Display character locally
        jmp     Emulate                 ; Continue emulation
@@10:
        call    KeyWaiting              ; Check if key was pressed
        jz      Emulate                 ; Loop if not
        call    GetCh                   ; Else get keypress
        jnz     @@20                    ; Jump if not fn or ctrl key
        cmp     al, ExitKey             ; Program-exit key pressed?
        je      Exit                    ; Jump to Exit if yes
@@20:
        call    AsynchOut               ; Else send char on its way
        jmp     Emulate                 ; Loop until done

;-----  End of emulation.  Deinitialize Asynch package and exit.

Exit:
        call    AsynchStop              ; Halt Asynch package
        mov     ah,04Ch                 ; DOS function: Exit program
        mov     al,[exCode]             ; Return exit code value
        int     21h                     ; Call DOS. Terminate program

%NEWPAGE
;---------------------------------------------------------------
; DispChar/OneChar      Display any ASCII value
;---------------------------------------------------------------
; Input:
;       al = ASCII value (0..255)
; Output:
;       none
;
;       NOTE: Control codes are displayed as [13] [10] etc. for
;       debugging a serial I/O line.
; Registers:
;       ax, cx, dl, di
;---------------------------------------------------------------
PROC    DispChar
        cmp     al, 32                  ; Is character a control?
        jae     OneChar                 ; Jump if not

;-----  Display bracketed control codes

        xor     ah, ah                  ; Convert al to 16-bit value
        mov     cx, 1                   ; Specify at least one char
        mov     di, offset string       ; Address string variable
        call    BinToAscDec             ; Convert to string
        mov     al, '['                 ; Display [ char
        call    OneChar                 ; Display char in al
        call    StrWrite                ; Display ctrl-code string
        mov     al, ']'                 ; "Fall through" to OneChar

PROC    OneChar
        mov     dl, al                  ; Assign char to dl
        mov     ah, 2                   ; DOS output-char function
        int     21h                     ; Call DOS to display char
        ret                             ; Return to caller
ENDP    OneChar

ENDP    DispChar

        END     Start        ; End of program / entry point
