%TITLE "Subroutine demonstration -- by Tom Swan"

        IDEAL

        MODEL   small
        STACK   256

        DATASEG

exCode          DB      0

        CODESEG

Start:  
        mov     ax, @data       ; Initialize DS to address
        mov     ds, ax          ;  of data segment

        mov     al, 1           ; Load AL-DL with values
        mov     bl, 2           ;  to add
        mov     cl, 3
        mov     dl, 4
        call    AddRegisters    ; AX <- AL+BL+CL+DL
        call    AddRegisters    ;  again
        call    AddRegisters    ;   and again!

Exit:
        mov     ah, 04Ch        ; DOS function: Exit program
        mov     al, [exCode]    ; Return exit code value
        int     21h             ; Call DOS. Terminate program

;---------------------------------------------------------------
; AddRegisters          Sum al, bl, cl, and dl
;---------------------------------------------------------------
; Input:
;       al, bl, cl, dl = Four 8-bit values to add
; Output:
;       ax = al + bl + cl + dl
; Registers:
;       ax, bh, ch, dh changed
;---------------------------------------------------------------
PROC    AddRegisters
        xor     ah, ah          ; Set ah equal to zero
        xor     bh, bh          ; Set bh equal to zero
        xor     ch, ch          ; Set ch equal to zero
        xor     dh, dh          ; Set dh equal to zero
        add     ax, bx          ; AX <- AX + BX
        adc     ax, cx          ; AX <- AX + CX + CF
        adc     ax, dx          ; AX <- AX + DX + CF
        ret                     ; Return to caller
ENDP    AddRegisters

        END     Start           ; End of program / entry point
