PROGRAM StringConversion;

{ Convert ASCIIZ strings and Pascal strings }

TYPE  ASCIIZString = ARRAY[ 0 .. 255 ] OF Char;
      ASCIIZptr    = ^ASCIIZString;

VAR   a : ASCIIZString;
      s : String;





{ Convert an ASCIIZ string (a) to a Pascal string (s) }

PROCEDURE ASCIIZtoStr( a : ASCIIZString; VAR s : String );


VAR len : Integer;
BEGIN
  len := 0;
  WHILE ( len < 255 ) AND ( a[ len ] <> Chr( 0 ) ) DO
  BEGIN
    len := len + 1;
    s[ len ] := a[ len - 1 ]
  END; { while }
  s[ 0 ] := Chr( len )
END; { ASCIIZtoStr }



{ Convert a Pascal string (s) to an ASCIIZ string (a) }

PROCEDURE StrToASCIIZ( s : String; VAR a : ASCIIZString );


VAR len, i : Integer;
BEGIN
  len := Length( s );
  FOR i := 1 TO len DO
    a[ i - 1 ] := s[ i ];
  a[ len ] := Chr( 0 )
END; { StrToASCIIZ }



{ Display an ASCIIZ string }

PROCEDURE ShowASCIIZ( a : ASCIIZString );
VAR i : Integer;
BEGIN
  i := 0;
  WHILE ( i < 255 ) AND ( a[ i ] <> Chr(0) ) DO
  BEGIN
    Write( a[ i ] );
    i := i + 1
  END { while }
END; { ShowASCIIZ }   


BEGIN
  s := 'This is a test';
  StrtoASCIIZ( s, a );
  ShowASCIIZ( a );
  Writeln;
  s := '';
  ASCIIZtoStr( a, s );
  Writeln( s )
END.
