%TITLE "ASCIIZ and Pascal Strings -- Copyright (c) 1989,1995 by Tom Swan"

        IDEAL

        MODEL   TPASCAL

        CODESEG

        PUBLIC  ASCIIZtoStr, StrToASCIIZ

%NEWPAGE
;---------------------------------------------------------------
; PROCEDURE ASCIIZtoStr( a : ASCIIZString; VAR s : String );
;---------------------------------------------------------------
PROC    ASCIIZtoStr     NEAR
        ARG a:dword, s:dword = ArgSize
        push    ds                      ; Save Pascal's ds register
        les     di, [s]                 ; Address s with es:di
        push    di                      ; Save address for later
        inc     di                      ; Address s[1] with es:di
        lds     si, [a]                 ; Address a with ds:si
        cld                             ; Auto-increment si, di
        xor     cl, cl                  ; Set len (cl) to zero
@@10:
        cmp     cl, 255                 ; Is len = 255 yet?
        je      @@20                    ; If yes, exit
        lodsb                           ; Get char (al <- a[I])
        or      al, al                  ; Is al = 0 (ASCII null)?
        jz      @@20                    ; If char = null, exit
        inc     cl                      ; len := len + 1
        stosb                           ; s[ len ] := a[ len - 1 ]
        jmp     @@10                    ; Loop until done
@@20:
        pop     di                      ; es:di again addresses s[0]
        mov     [byte es:di], cl        ; s[ 0 ] := Chr( len )
        pop     ds                      ; Restore Pascal's ds register
        ret                             ; Return to caller
ENDP    ASCIIZtoStr

%NEWPAGE
;---------------------------------------------------------------
; PROCEDURE StrToASCIIZ( s : String; VAR a : ASCIIZString );
;---------------------------------------------------------------
PROC    StrToASCIIZ     NEAR
        ARG s:dword, a:dword = ArgSize
        push    ds                      ; Save Pascal's ds register
        les     di, [a]                 ; Address a with es:di
        lds     si, [s]                 ; Address s with ds:si
        cld                             ; Auto-increment si, di
        xor     ch, ch                  ; Zero upper half of cx
        lodsb                           ; al := Length( s )
        mov     cl, al                  ; cx = string length
        jcxz    @@10                    ; Exit if length = 0
        repnz   movsb                   ; Transfer s to a
@@10:
        mov     [byte es:di], cl        ; a[ len ] := Chr( 0 )
        pop     ds                      ; Restore Pascal's ds register
        ret                             ; Return to caller
ENDP    StrToASCIIZ

        END                     ; End of module
