%TITLE "Slow Motion Interrupt -- Copyright (c) 1989,1995 by Tom Swan"

        IDEAL

        MODEL   small
        STACK   256

delay           EQU     0010h           ; Amount of delay
cr              EQU     13              ; ASCII carriage return
lf              EQU     10              ; ASCII line feed
BIOSData        EQU     040h            ; BIOS data segment address
LowTimer        EQU     006Ch           ; Address of low timer word
PIC8259         EQU     0020h           ; 8259 PIC chip port address
EOI             EQU     0020h           ; End of interrupt value

        DATASEG

exCode          DB      0
string          DB      'This is a test of the timer', cr, lf
                DB      ' slow-mo interrupt handler', cr, lf, 0
timerSeg        DW      ?               ; Saved vector for original
timerOfs        DW      ?               ;  Int 1Ch ISR


        CODESEG

;-----  From STRIO.OBJ, KEYBOARD.OBJ
        EXTRN   StrWrite:proc, KeyWaiting:proc

Start:  
        mov     ax, @data               ; Initialize DS to address
        mov     ds, ax                  ;  of data segment
        mov     es, ax                  ; Make es = ds

        mov     [word cs:difference],delay  ; Set amount of delay

        push    es                      ; Save es register
        mov     ax, 351Ch               ; Get interrupt 1C vector
        int     21h                     ; Call DOS for vector
        mov     [timerSeg], es          ; Save segment value
        mov     [timerOfs], bx          ; Save offset value
        pop     es                      ; Restore es

        push    ds                      ; Save ds register
        mov     ax, 251Ch               ; Set interrupt 1C vector
        push    cs                      ; Make ds = cs to address
        pop     ds                      ;  the new ISR, placing full
        mov     dx, offset SlowMo       ;  address into ds:dx
        int     21h                     ; Set new interrupt vector
        pop     ds                      ; Restore ds

        mov     di, offset string       ; Address test string
@@10:
        call    StrWrite                ; Display string
        call    KeyWaiting              ; Check for a keypress
        jz      @@10                    ; Loop until any keypress

        push    ds                      ; Save ds, changed below
        mov     ax, 251Ch               ; Set interrupt 1C vector
        mov     dx, [timerOfs]          ; Get saved offset value
        mov     ds, [timerSeg]          ; Get saved segment value
        int     21h
        pop     ds                      ; Restore ds
Exit:
        mov     ah, 04Ch                ; DOS function: Exit program
        mov     al, [exCode]            ; Return exit code value
        int     21h                     ; Call DOS. Terminate program

%NEWPAGE
;---------------------------------------------------------------
; SlowMo        Slow Motion Timer Interrupt Service Routine
;---------------------------------------------------------------
; Input:
;       none
; Output:
;       none (waits for time difference)
; Registers:
;       none
;---------------------------------------------------------------

;-----  Variables declared inside the code segment, where they
;       will be easy to find during execution of the ISR

inProgress      DB      0       ; In-progress flag (0=no, 1=yes)
difference      DW      0       ; Relative pause time

PROC    SlowMo

;-----  Test the inProgress flag, which indicates if a previous
;       copy of SlowMo is already executing.  This must be prevented
;       or the system will lock up.

        cmp     [byte cs:inProgress], 0 ; Check in-progress flag
        jne     @@99                    ; Jump if SlowMo is running
        inc     [byte cs:inProgress]    ; Else, set flag = 1

        sti                             ; Allow interrupts to occur
        push    ax                      ; Save modified registers
        push    ds
        push    dx

        mov     al, EOI                 ; al = end-of-interrupt value
        out     PIC8259, al             ; Issue end of interrupt

        mov     ax, BIOSData            ; Address BIOS data area
        mov     ds, ax                  ;  with ds
        mov     ax, [word LowTimer]     ; Get low word of timer value
@@10:
        mov     dx, [word LowTimer]     ; Get new timer value into dx
        sub     dx, ax                  ; Subtract new-old timer
        cmp     dx, [cs:difference]     ; Compare to difference
        jb      @@10                    ; Loop until difference passes

;-----  Disable interrupts while we clean up and exit after the pause

        cli                             ; Disable interrupts
        dec     [byte cs:inProgress]    ; Reset in-progress flag
        pop     dx                      ; Restore saved registers
        pop     ds
        pop     ax
@@99:
        iret                            ; Interrupt return
ENDP    SlowMo

        END     Start        ; End of program / entry point
