%TITLE "Single-Step (Trap) Demo -- Copyright (c) 1989,1995 by Tom Swan"

        IDEAL

        MODEL   small
        STACK   256

cr              EQU     13              ; ASCII carriage return
lf              EQU     10              ; ASCII line feed
Trapping        EQU     0               ; "Single-stepping is enabled"
TurnOnTrap      EQU     1               ; Code to enable single-step
TurnOffTrap     EQU     2               ; Code to disable single-step


        DATASEG

exitC           DB      0

spaces          DB      '    ', 0       ; String of 4 blank characters

offMsg          DB      cr, lf, 'Single-step trap is off', cr, lf, 0
onMsg           DB      cr, lf, 'Single-step trap is on', cr, lf, 0
pauseMsg        DB      'Press any key to continue...', 0
countMsg        DB      cr, lf, lf, 'Count = 50!', cr, lf, 0

trapSwitch      DB      0               ; Trap enable/disable switch
string          DB      40 DUP (?)      ; Miscellaneous string
count           DW      ?               ; For Counter subroutine
trapSeg         DW      ?               ; Old int type 1
trapOfs         DW      ?               ;  vector address


        CODESEG

;-----  From STRIO.OBJ, BINASC.OBJ, KEYBOARD.OBJ
        EXTRN   StrWrite:proc, NewLine:proc, BinToAscDec:proc
        EXTRN   GetCh:proc

Start:  
        mov     ax, @data               ; Initialize DS to address
        mov     ds, ax                  ;  of data segment
        mov     es, ax                  ; Make es = ds

;-----  Save int type 1 vector and reassign to Stepper ISR

        mov     ax, 3501h               ; Get int type 1 vector
        int     21h                     ; Call DOS
        mov     [trapSeg], es           ; Save segment value
        mov     [trapOfs], bx           ; Save offset value
        push    ds                      ; Save current ds register
        mov     ax, 2501h               ; Set int type 1 vector
        push    cs                      ;  to the address of
        pop     ds                      ;  the Stepper ISR
        mov     dx, offset Stepper
        int     21h
        pop     ds                      ; Restore ds
        push    ds                      ; Set es equal to ds
        pop     es

;-----  Execute sample code at full speed

        mov     di, offset offMsg       ; Display "Trapping is off"
        call    Counter                 ; Call sample subroutine

;-----  Execute sample code in single-step mode

        mov     di, offset onMsg        ; Display "Trapping is on"
        mov     [trapSwitch], TurnOnTrap        ; Tell ISR to turn
        int     1                               ;  on trapping
        call    Counter                 ; Call sample subroutine
        mov     [trapSwitch], TurnOffTrap       ; Tell ISR to turn
                                                ;  off trapping
;-----  Reexecute sample code at full speed

        mov     di, offset offMsg       ; Display "Trapping is off"
        call    Counter                 ; Call sample subroutine

Exit:
        push    ds                      ; Save current ds register
        mov     ax, 2501h               ; Reset int type 1 vector
        mov     ds, [trapSeg]           ;  to the address saved
        mov     dx, [trapOfs]           ;  at trapSeg and trapOfs
        int     21h
        pop     ds                      ; Restore ds
        mov     ah, 04Ch                ; DOS function: Exit program
        mov     al, [exitC]             ; Return exit code value
        int     21h                     ; Call DOS. Terminate program


;-----  Subroutine: Displays string, pauses, and counts to 100

PROC    Counter
        call    StrWrite                ; Display id message
        call    Pause                   ; Wait for keypress
        mov     [count], 0              ; Zero count
@@10:
        inc     [count]                 ; count <- count + 1
        mov     ax, [count]             ; Convert count to string
        mov     cx, 4                   ; Minimum string size
        mov     di, offset string
        call    BinToAscDec
        call    StrWrite                ; Display string
        mov     di, offset spaces       ; Display 4 blanks
        call    StrWrite
        cmp     [count], 100            ; Repeat until count = 100
        jb      @@10
        ret                             ; Return to caller
ENDP    Counter


;-----  Subroutine: Display message and wait for keypress

PROC    Pause
        mov     di, offset pauseMsg     ; Display pause message
        call    StrWrite
        call    GetCh                   ; Wait for a keypress
        call    NewLine                 ; Start new display line
        ret                             ; Return to caller
ENDP    Pause


%NEWPAGE
;---------------------------------------------------------------
; Stepper       Single-Step trap ISR
;---------------------------------------------------------------
; Input:
;       [trapSwitch] = TurnOnTrap
;               Single-step mode enabled
;       [trapSwitch] = TurnOffTrap
;               Single-step mode disabled
;       [trapSwitch] = ???
;               no action
; Output:
;       none
; Registers:
;       none
;---------------------------------------------------------------
PROC    Stepper
        sti                             ; Allow interrupts
        push    bp                      ; Save current bp register
        mov     bp, sp                  ; Address stack with bp
        push    ax                      ; Save all registers
        push    bx
        push    cx
        push    dx
        push    di
        push    si
        push    ds
        push    es

;-----  Address local data with ds, es

        mov     ax, @data               ; Initialize DS to address
        mov     ds, ax                  ;  of data segment
        mov     es, ax                  ; Make es = ds

;-----  Test trapSwitch to turn single-step mode on/off

        cmp     [trapSwitch], TurnOnTrap
        jne     @@10
        or      [word bp+6], 0100h      ; Set tf (enable trap)
        mov     [trapSwitch], Trapping  ; "Trapping is enabled"
        jmp     @@99                    ; Exit
@@10:
        cmp     [trapSwitch], TurnOffTrap
        jne     @@20
        and     [word bp+6], 0FEFFh     ; Reset tf (disable trap)
        jmp     @@99                    ; Exit

@@20:

;-----  Insert single-stepping trap code here

        cmp     [count], 50             ; Is count = 50
        jne     @@99                    ; If not, exit
        mov     di, offset countMsg     ; Else display count message
        call    StrWrite
        call    Pause                   ; And wait for keypress
        inc     [count]         ; To allow program to continue
        call    NewLine

@@99:
        pop     es                      ; Restore all registers
        pop     ds
        pop     si
        pop     di
        pop     dx
        pop     cx
        pop     bx
        pop     ax
        pop     bp
        iret                            ; Return from interrupt
ENDP    Stepper

        END     Start        ; End of program / entry point
