%TITLE "Display DOS Command-Line Params -- Copyright (c) 1989,1995 by Tom Swan"

        IDEAL

        MODEL   small
        STACK   256

        DATASEG

exCode          DB      0
string          DB      20 DUP (0)
s1              DB      'Number of parameters = ', 0

        CODESEG

;-----  From PARAMS.OBJ
        EXTRN   ParamCount:Proc, GetParams:Proc, GetOneParam:Proc

;-----  From BINASC.OBJ, STRINGS.OBJ, STRIO.OBJ
        EXTRN   BinToAscDec:Proc, NewLine:Proc, StrWrite:Proc
        EXTRN   BinToAscHex:Proc, StrUpper:Proc

Start:  
        mov     ax, @data               ; Set ax to data segment
        mov     es, ax                  ; Set es to data segment
        call    GetParams               ; Get parameters with ds = PSP
                                        ; Note: ds now equals es

;-----  Display number of parameters

        call    NewLine                 ; Start new display line
        mov     di, offset s1           ; Address string
        call    StrWrite                ; Display string
        call    ParamCount              ; Get number of parameters
        mov     ax, dx                  ; Assign count to ax
        mov     cx, 1                   ; Specify at least one digit
        mov     di, offset string       ; Address work string
        call    BinToAscDec             ; Convert ax to decimal digits
        call    StrWrite                ; Display number
        call    NewLine                 ; Start a new display line

        xor     cx, cx                  ; Initialize count to zero
@@10:
        call    ParamCount              ; Get number of parameters
        cmp     cx, dx                  ; Compare counter to number
        je      Exit                    ; Exit when cx = dx
        push    cx                      ; Save cx on stack
        call    GetOneParam             ; Get address of one parameter
        call    StrUpper                ; Convert to uppercase
        call    StrWrite                ; Display parameter string
        call    NewLine                 ; Start a new display line
        pop     cx                      ; Restore saved cx value
        inc     cx                      ; Advance to next parameter
        jmp     @@10                    ; Repeat until done
Exit:
        mov     ah, 04Ch                ; DOS function: Exit program
        mov     al, [exCode]            ; Return exit code value
        int     21h                     ; Call DOS. Terminate program

        END     Start        ; End of program / entry point
