%TITLE "Shift instruction demonstration -- by Tom Swan"

        IDEAL

        MODEL   small
        STACK   256

        DATASEG

exCode          DB      0
operand         DB      0AAh

        CODESEG

Start:  
        mov     ax, @data       ; Initialize DS to address
        mov     ds, ax          ;  of data segment

        shl     [operand], 1    ; Shift left
        shr     [operand], 1    ; Shift right
        rol     [operand], 1    ; Rotate left
        ror     [operand], 1    ; Rotate right
        rcl     [operand], 1    ; Rotate left through carry
        rcr     [operand], 1    ; Rotate right through carry
        sal     [operand], 1    ; Shift arithmetic left
        sar     [operand], 1    ; Shift arithmetic right

Exit:
        mov     ah, 04Ch        ; DOS function: Exit program
        mov     al, [exCode]    ; Return exit code value
        int     21h             ; Call DOS. Terminate program

        END     Start           ; End of program / entry point
