%TITLE "Perform Warm Reboot -- Copyright (c) 1989,1995 by Tom Swan"

        IDEAL

        MODEL   small
        STACK   256

WarmBoot        EQU     1234h           ; Skips cold boot tests
ColdBoot        EQU     1234d           ; Other value may work

BIOSDataLoc     EQU     0040h           ; Segment address of BIOS data
BIOSLoc         EQU     0F000h          ; Segment address of BIOS code
ResetFlagLoc    EQU     0072h           ; Offset to ResetFlag in BIOS data
ResetLoc        EQU     0E05Bh          ; Offset to ResetLoc in BIOS code


;-----  Tell assembler where the ResetFlag word is located

SEGMENT BIOSData at BIOSDataLoc
        ORG     ResetFlagLoc
LABEL   ResetFlag Word
ENDS

        CODESEG

Start:  
        mov     ax, BIOSDataLoc         ; Address BIOSData segment
        mov     ds,ax                   ;  with ds

ASSUME  DS:BIOSData

        mov     [ResetFlag],WarmBoot    ; Set ResetFlag
        jmp     far BIOSLoc:ResetLoc    ; Jump to Reset routine

        END     Start        ; End of program / entry point
