%TITLE "Select 132-char printer output -- by Tom Swan"

        IDEAL

        MODEL   small
        STACK   256

        DATASEG

; Insert the codes that select your printer's 132-character (or
; greater) output style, sometimes called "compressed" mode.  
; The values below should work with most Epson-compatible printers.
; The last value must be 0!

prCodes         DB      27, 15, 0   ; Must end in 0!

        CODESEG

Start:  
        mov     ax, @data           ; Initialize DS to address
        mov     ds, ax              ;  of data segment

        cld                         ; Clear df--auto increment si
        mov     si, offset prCodes  ; Point si to prCodes
Next:
        lodsb                       ; Load next code into al
        or      al, al              ; Is al = 0?
        jz      Exit                ; If yes, jump to exit
        mov     dl, al              ;  else assign al to dl
        mov     ah, 05h             ; DOS print char function
        int     21h                 ; Call DOS.  Print char.
        jmp     Next                ; Do next code.
Exit:
        mov     ax, 04C00h          ; DOS function: Exit program
        int     21h                 ; Call DOS.  Terminate program

        END     Start           ; End of program / entry point
