{ Test program, to be linked to externals in PASDEMO.OBJ }

{$D+}    { Include debugging information }

PROGRAM PasDemo;

CONST
  value: Integer = 1234;  { Typed-constant declaration }

TYPE
  IntPtr = ^Integer;      { Pointer to integer type }

VAR
  cr, lf : Char;          { Global variables }

PROCEDURE PasProc; FORWARD;       { Must come before $L directive }
FUNCTION PasFunc: Char; FORWARD;

{$L PASDEMO.OBJ}                  { Load the assembled object code }

{ External declarations, telling Pascal the format of the
external routines in PASDEMO.ASM. }

PROCEDURE AsmProc; EXTERNAL;
FUNCTION CountPtr: IntPtr; EXTERNAL;

PROCEDURE PasProc;
VAR I: Integer;            { Can't be exported to ASM module }
BEGIN
  Writeln('PasProc: Inside the Pascal procedure')
END; { PasProc }

FUNCTION PasFunc: Char;
BEGIN
  PasFunc := '#'           { Pass a character to ASM module }
END; { PasFunc }

BEGIN
  cr := chr(13);
  lf := chr(10);
  AsmProc;
  Writeln('Main: asmCount = ', countPtr^)
END.
