%TITLE "Test Pascal .OBJ module -- Copyright (c) 1989,1995 by Tom Swan"

        IDEAL

;-----  Data segment combines with Pascal's global data segment

SEGMENT DATA word public

;-----  Import typed constants and variables from Pascal
        EXTRN   value : WORD, cr : BYTE, lf : BYTE

asmCount        dw      ?       ; Static variable

ENDS    DATA


;-----  Code segment combines with Pascal's main program

SEGMENT CODE byte public

ASSUME  cs:CODE, ds:DATA        ; Explain memory model to assembler

;-----  Export public procedures to Pascal
        PUBLIC  AsmProc, CountPtr

;-----  Import procedures and functions from Pascal
        EXTRN   PasProc : NEAR, PasFunc : NEAR


;---------------------------------------------------------------
; PROCEDURE AsmProc;
;---------------------------------------------------------------

;-----  Preinitialized variables must go in the code segment
testString      db      'AsmProc: Should be a "hatch mark" --> ', '$'

PROC    AsmProc NEAR

;-----  Call a Pascal procedure

        call    PasProc                 ; pasProc is in PASDEMO.PAS

;-----  Use local data stored in the code segment

        push    ds                      ; Save Pascal's ds register
        push    cs                      ; Address code segment with
        pop     ds                      ;  register ds
ASSUME  ds : CODE                       ; Inform assembler
        mov     dx, offset testString   ; Address the test string
        mov     ah, 09h                 ; Display the test string by
        int     21h                     ;  calling DOS function 9
        pop     ds                      ; Restore Pascal's ds register
ASSUME  ds : DATA                       ; Inform assembler


;-----  Get typed-constants from Pascal and use local static variables

        mov     ax, [value]             ; Get value from Pascal
        mov     [asmCount], ax          ; Initialize static variable


;-----  Call a Pascal function for a character value

        call    PasFunc                 ; Get test char from Pascal
        mov     dl, al                  ; Assign char to dl
        mov     ah, 2                   ; Display char with DOS
        int     21h                     ;  function 2


;-----  Get variables from Pascal

        mov     ah, 2                   ; DOS display-char function
        mov     dl, [cr]                ; Get cr from Pascal
        int     21h                     ; Perform carriage return
        mov     dl, [lf]                ; Get lf from Pascal
        int     21h                     ; Perform line feed
        ret                             ; Return to caller

ENDP    AsmProc


%NEWPAGE
;---------------------------------------------------------------
; FUNCTION CountPtr : intPtr;
;---------------------------------------------------------------
PROC    CountPtr        NEAR
        mov     dx, SEG asmCount        ; Pass segment address in dx
        mov     ax, OFFSET asmCount     ; Pass offset address in ax
        ret                             ; Return to caller
ENDP    CountPtr

ENDS    CODE                    ; End of code segment

        END                     ; End of module
