%TITLE "Parse DOS Command-Line Params -- Copyright (c) 1989,1995 by Tom Swan"

        IDEAL

        MODEL   small


TailLen         EQU     0080h           ; Offset of param len byte
CommandTail     EQU     0081h           ; Offset of parameters


        DATASEG

numParams       DW      ?               ; Number of parameters
params          DB      128 DUP (?)     ; 128-byte block for strings


        CODESEG

        PUBLIC  ParamCount, GetParams, GetOneParam

%NEWPAGE
;---------------------------------------------------------------
; Separators    Private routine to check for blanks, tabs, and crs
;---------------------------------------------------------------
; Input:
;       ds:si addresses character to check
; Output:
;       zf = 1 (je)  = character is a blank, tab, or cr
;       zf = 0 (jne) = character is not a separator
; Registers:
;       al
;---------------------------------------------------------------
PROC    Separators
        mov     al, [si]                ; Get character at ds:si
        cmp     al, 020h                ; Is char a blank?
        je      @@10                    ; Jump if yes
        cmp     al, 009h                ; Is char a tab?
        je      @@10                    ; Jump if yes
        cmp     al, 00Dh                ; Is char a cr?
@@10:
        ret                             ; Return to caller
ENDP    Separators
%NEWPAGE
;---------------------------------------------------------------
; ParamCount    Return number of parameters
;---------------------------------------------------------------
; Input:
;       none
; Output:
;       dx = number of command-line parameters
;       Note: When calling GetOneParam, cx should be less
;        than the value returned in dx by ParamCount
; Registers:
;       dx
;---------------------------------------------------------------
PROC    ParamCount
        mov     dx, [numParams]         ; Get value from variable
        ret                             ; Return to caller
ENDP    ParamCount
%NEWPAGE
;---------------------------------------------------------------
; GetParams     Get DOS Command-Line Parameters
;---------------------------------------------------------------
; Input:
;       ds = Program Segment Prefix (PSP)
;       es = Program's data segment
;       Note: until you change it, ds addresses the PSP
;        when all .EXE programs begin
; Output:
;       global params filled with ASCIIZ strings
;       [numParams] = number of parameters
;       ds = Program's data segment (es not changed)
; Registers:
;       al, bx, dx, si, di, ds
;---------------------------------------------------------------
PROC    GetParams

;-----  Initialize counter (cx) and index registers (si,di)

        xor     ch, ch                  ; Zero upper half of cx
        mov     cl, [ds:TailLen]        ; cx = length of parameters
        inc     cx                      ; Include cr at end
        mov     si, CommandTail         ; Address parameters with si
        mov     di, offset params       ; Address destination with di

;-----  Skip leading blanks and tabs

@@10:
        call    Separators              ; Skip leading blanks & tabs
        jne     @@20                    ; Jump if not a blank or tab
        inc     si                      ; Skip this character
        loop    @@10                    ; Loop until done or cx=0

;-----  Copy parameter strings to global params variable

@@20:
        push    cx                      ; Save cx for later
        jcxz    @@30                    ; Skip movsb if count = 0
        cld                             ; Auto-increment si and di
        rep     movsb           ; copy cx bytes from ds:si to es:di

;-----  Convert blanks to nulls and set numParams

@@30:
        push    es                      ; Push es onto stack
        pop     ds                      ; Make ds = es
        pop     cx                      ; Restore length to cx
        xor     bx, bx                  ; Initialize parameter count
        jcxz    @@60                    ; Skip loop if length = 0
        mov     si, offset params       ; Address parameters with si
@@40:
        call    Separators              ; Check for blank, tab, or cr
        jne     @@50                    ; Jump if not a separator
        mov     [byte ptr si], 0        ; Change separator to null
        inc     bx                      ; Count number of parameters
@@50:
        inc     si                      ; Point to next character
        loop    @@40                    ; Loop until cx equals 0
@@60:
        mov     [numParams], bx         ; Save number of parameters
        ret                             ; Return to caller
ENDP    GetParams
%NEWPAGE
;---------------------------------------------------------------
; GetOneParam   Get one parameter address by number
;---------------------------------------------------------------
; Input:
;       cx = parameter number (0=first)
;       Note: cx should always be less than the value
;        returned in dx by ParamCount
; Output:
;       di = offset of ASCIIZ string for this parameter
; Registers:
;       al, cx, di
;---------------------------------------------------------------
PROC    GetOneParam
        xor     al, al                  ; Init search value to 0
        mov     di, offset params       ; Address parameter strings
        jcxz    @@99                    ; If number=0, jump to exit
        cmp     cx, [numParams]         ; Compare number with max
        jae     @@99                    ; Exit if > maximum number
        cld                             ; Auto-increment di
@@10:
        scasb                           ; Scan for null terminator
        jnz     @@10                    ; Repeat until found
        loop    @@10                    ; Repeat for count in cx
@@99:
        ret                             ; Return to caller
ENDP    GetOneParam

        END                  ; End of module
