%TITLE "Virtual function demonstration -- by Tom Swan"

        IDEAL

        JUMPS

        LOCALS @@

        MODEL large, PASCAL

        STACK 1000H

        INCLUDE "..\oomacros.inc"

        INCLUDE "tbase.inc"

        INCLUDE "tderived.inc"

        DATASEG

exCode  db      0               ; Program exit code

;----- Define objects with no default values

b1      TBase    <>
d1      TDerived <>

;----- Define objects with explicit default values
;      and place holders (0) for VMT pointers

b2      TBase    <0, 987>
d2      TDerived <<0, 654>, 321>

;----- Define objects with explicit default values
;      and explicit vmt pointers.

b3      TBase    <@TableAddr_TBase, 987>
d3      TDerived <<@TableAddr_TDerived, 654>, 321>


        CODESEG

Start:  
        mov     ax, @data       ; Initialize DS to address
        mov     ds, ax          ;  of data segment

        mov     si, offset b1                     ; Address instance b1
        LoadVMTSeg  es                            ; Initialize es (VMT seg)
        CALL si METHOD TBase:construct            ; Prepare b1's VMT ptr
        CALL si METHOD TBase:init, 01h            ; Initialize instance data
        CALL TBase PTR si METHOD TBase:action     ; Call virtual function

        mov     si, offset d1                     ; Address instance d1
        LoadVMTSeg  es                            ; Initialize es
        CALL si METHOD TDerived:construct         ; Static function call
        CALL si METHOD TDerived:init, 02h, 03h    ; Static function call
        CALL TBase PTR si METHOD TBase:action     ; Virtual function call

        mov     si, offset d1
        LoadVMTSeg  es
        CALL TBase PTR si METHOD TBase:action     ; Calls TDerived:action

        mov     si, offset b2
        LoadVMTSeg  es
        CALL si METHOD TBase:construct
        CALL TBase PTR si METHOD TBase:action     ; Calls TBase:action

        mov     si, offset d2
        LoadVMTSeg  es
        CALL si METHOD TDerived:construct
        CALL TBase PTR si METHOD TBase:action     ; Calls TDerived:action

        mov     si, offset b3
        LoadVMTSeg  es
        CALL TBase PTR si METHOD TBase:action     ; Calls TBase:action

        mov     si, offset d3
        LoadVMTSeg  es
        CALL TBase PTR si METHOD TBase:action     ; Calls TDerived:action

Exit:
        mov     ah, 04Ch        ; DOS function: Exit program
        mov     al, [exCode]    ; Return exit code value
        int     21h             ; Call DOS.  Terminate program

        END     Start           ; End of program / entry point
