%TITLE "TDerived object -- by Tom Swan"

GLOBAL TDerived_construct:PROC
GLOBAL TDerived_init:PROC
GLOBAL TDerived_getData:PROC
GLOBAL TDerived_action:PROC

STRUC TDerived TBase METHOD {
  construct:mptr      = TDerived_construct  ; Instance constructor
  init:mptr           = TDerived_init       ; Instance initializer
  getData:mptr        = TDerived_getData    ; Replacement static method
  VIRTUAL action:mptr = TDerived_action     ; Replacement virtual method
}
  TDerived_data  dw      ?                  ; TDerived object data
ENDS TDerived

Make_VMT        ; Define TDerived VMT

CODESEG

;---------------------------------------------------------------
; TDerived_construct    TDerived constructor
;---------------------------------------------------------------
; Input:
;       ds:si = instance address
; Output:
;       VMT ptr initialized
; Registers:
;       none
;---------------------------------------------------------------
PROC    TDerived_construct  PASCAL
        TBLINIT TBase PTR si        ; Initialize instance VMT pointer
        ret
ENDP    TDerived_construct

;---------------------------------------------------------------
; TDerived_init         TDerived init method 
;---------------------------------------------------------------
; Input:
;       ds:si = instance address
;       arg1 = word to store in base instance data
;       arg2 = word to store in derived instance data
; Output:
;       arg1 -> instance.TBase_data
;       arg2 -> instance.TDerived_data
; Registers:
;       none
;---------------------------------------------------------------
PROC    TDerived_init PASCAL
        ARG     @@data1:word, \     ; Create stack offsets to arguments
                @@data2:word
        USES    ax                          ; Preserve ax (optional)
        mov     ax, [@@data1]               ; Move arg1 into ax
        CALL    si METHOD TBase:init, ax    ; Call base init method
        mov     ax, [@@data2]               ; Move arg2 into ax
        mov     [(TDerived PTR si).TDerived_data], ax  ; Store in instance
        ret
ENDP    TDerived_init

; ----- Preceding mov and call statements can also be written as:
;       CALL    si METHOD TBase:init, [@@data1]

;---------------------------------------------------------------
; TDerived_getData      TDerived getData method
;---------------------------------------------------------------
; Input:
;       ds:si = instance address
; Output:
;       ax = instance.TBase_data
;       dx = instance.TDerived_data
; Registers:
;       ax, dx
;---------------------------------------------------------------
PROC    TDerived_getData  PASCAL 
        CALL    si METHOD TBase:getData                ; ax <- base data
        mov     dx, [(TDerived PTR si).TDerived_data]  ; dx <- derived data
        ret
ENDP    TDerived_getData

;---------------------------------------------------------------
; TDerived_action       TDerived action VIRTUAL method
;---------------------------------------------------------------
; Input:
;       ds:si = instance address
; Output:
;       ax = 0ffffh (arbitrary operation for demo)
; Registers:
;       ax
;---------------------------------------------------------------
PROC    TDerived_action  PASCAL 
        mov     ax, 0ffffh          ; ax <- 0ffffh
        ret
ENDP    TDerived_action

;----- Use this to call ancestor function in TDerived_action:
;       call    TBase_action
