%TITLE "TBase object -- by Tom Swan"

GLOBAL TBase_construct:PROC
GLOBAL TBase_init:PROC
GLOBAL TBase_getData:PROC
GLOBAL TBase_action:PROC

STRUC TBase METHOD {
  construct:mptr      = TBase_construct ; Instance constructor
  init:mptr           = TBase_init      ; Instance initializer
  getData:mptr        = TBase_getData   ; Static method
  VIRTUAL action:mptr = TBase_action    ; Virtual method
}
  TBLPTR                                ; Virtual method table pointer
  TBase_data     dw      ?              ; TBase object data
ENDS  TBase

Make_VMT        ; Define TBase VMT

CODESEG

;---------------------------------------------------------------
; TBase_construct   TBase constructor (initialize VMT pointer)
;---------------------------------------------------------------
; Input:
;       ds:si = instance address
; Output:
;       VMT ptr initialized
; Registers:
;       none
;---------------------------------------------------------------
PROC    TBase_construct  PASCAL
        TBLINIT TBase PTR si        ; Initialize instance VMT pointer
        ret
ENDP    TBase_construct

;---------------------------------------------------------------
; TBase_init        TBase init method (initialize instance data)
;---------------------------------------------------------------
; Input:
;       ds:si = instance address
;       arg1 = word to store in instance
; Output:
;       arg1 -> instance.TBase_data
; Registers:
;       none
;---------------------------------------------------------------
PROC    TBase_init  PASCAL 
        ARG     @@data:word         ; Create offset to argument on stack
        USES    ax                  ; Preserve ax register (optional)
        mov     ax, [@@data]        ; Move argument into ax
        mov     [(TBase PTR si).TBase_data], ax     ; Save ax in instance
        ret
ENDP    TBase_init

;---------------------------------------------------------------
; TBase_getData     TBase getData method
;---------------------------------------------------------------
; Input:
;       ds:si = instance address
; Output:
;       ax = instance.TBase_data
; Registers:
;       ax
;---------------------------------------------------------------
PROC    TBase_getData  PASCAL 
        mov     ax, [(TBase PTR si).TBase_data]  ; ax <- base data
        ret
ENDP    TBase_getData

;---------------------------------------------------------------
; TBase_action      TBase action VIRTUAL method
;---------------------------------------------------------------
; Input:
;       ds:si = instance address
; Output:
;       ax = 0000 (arbitrary operation for demo)
; Registers:
;       ax
;---------------------------------------------------------------
PROC    TBase_action  PASCAL 
        xor     ax, ax              ; ax <- 0000h
        ret
ENDP    TBase_action
