%TITLE "TRect object -- by Tom Swan"

GLOBAL TRect_getCoords:PROC
GLOBAL TRect_setCoords:PROC

STRUC TRect METHOD {                ; Begin TRect object declaration
  getCoords:dword = TRect_getCoords ; Get coordinate values
  setCoords:dword = TRect_setCoords ; Set coordinate values
  }                                 ; End of method declarations
  left      dw      ?               ; Coordinates of upper-left and
  top       dw      ?               ; lower-right corners of
  right     dw      ?               ; the rectangle
  bottom    dw      ?
ENDS  TRect                         ; End TRect object declaration

CODESEG

%NEWPAGE
;---------------------------------------------------------------
; TRect_getCoords       TRect getCoords method
;---------------------------------------------------------------
; Input:
;       ds:si = instance address
; Output:
;       ax = left coordinate
;       bx = top coordinate
;       cx = right coordinate
;       dx = bottom coordinate
; Registers:
;       cx, dx, si, di
;---------------------------------------------------------------
PROC    TRect_getCoords PASCAL
        mov     ax, [(TRect PTR si).left]
        mov     bx, [(TRect PTR si).top]
        mov     cx, [(TRect PTR si).right]
        mov     dx, [(TRect PTR si).bottom]
        ret
ENDP    TRect_getCoords
%NEWPAGE
;---------------------------------------------------------------
; TRect_setCoords       TRect setCoords method
;---------------------------------------------------------------
; Input:
;       ds:si = instance address
;       left coordinate     (word, on stack)
;       top  coordinate     (word, on stack)
;       right coordinate    (word, on stack)
;       bottom coordinate   (word, on stack)
; Output:
;       none
; Registers:
;       ax
;---------------------------------------------------------------
PROC    TRect_setCoords PASCAL
        ARG     @@left:word, @@top:word, @@right:word, @@bottom:word
        mov ax, [@@left]
        mov [(TRect PTR si).left    ], ax
        mov ax, [@@top]
        mov [(TRect PTR si).top     ], ax
        mov ax, [@@right]
        mov [(TRect PTR si).right   ], ax
        mov ax, [@@bottom]
        mov [(TRect PTR si).bottom  ], ax
        ret
ENDP    TRect_setCoords
