%TITLE "TDateObj object -- by Tom Swan"

GLOBAL TDateObj_construct:PROC
GLOBAL TDateObj_init:PROC
GLOBAL TDateObj_setDate:PROC
GLOBAL TDateObj_getDate:PROC
GLOBAL TDateObj_print:PROC

STRUC TDateObj TItem METHOD {
  construct:mptr     = TDateObj_construct  ; TDateObj constructor
  init:mptr          = TDateObj_init       ; TDateObj initializer
  setDate:mptr       = TDateObj_setDate    ; Change or initialize date
  getDate:mptr       = TDateObj_getDate    ; Get day, month, year data
  VIRTUAL print:mptr = TDateObj_print      ; Print or display item
}
  year      dw      ?
  day       dw      ?
  month     db      ?
ENDS  TDateObj

Make_VMT        ; Define TDateObj VMT

DATASEG

dayBuf           db     '00'
daySep           db     '/'
monthBuf         db     '00'
monthSep         db     '/'
yearBuf          db     '0000', 0
TDateObj_msg     db      'Date item = ', 0

CODESEG

;-----  From BINASC.OBJ, STRIO.OBJ
        EXTRN   BinToAscDec:Proc, NewLine:Proc, StrWrite:Proc

;---------------------------------------------------------------
; TDateObj_construct   TDateObj constructor
;---------------------------------------------------------------
; Input:
;       ds:si = TDateObj instance address
; Output:
;       VMT ptr initialized
; Registers:
;       none
;---------------------------------------------------------------
PROC    TDateObj_construct  PASCAL
        TBLINIT TDateObj PTR si             ; Initialize VMT pointer
        ret
ENDP    TDateObj_construct

;---------------------------------------------------------------
; TDateObj_init        Initialize item "next" pointer
;---------------------------------------------------------------
; Input:
;       ds:si = TDateObj instance address
; Output:
;       instance data bytes set to zero
; Registers:
;       ax
;---------------------------------------------------------------
PROC    TDateObj_init  PASCAL
        CALL    si METHOD TItem:init
        CALL    si METHOD TDateObj:setDate, 0, 0, 0
        ret
ENDP    TDateObj_init

;---------------------------------------------------------------
; TDateObj_setDate      Change or initialize a TDateObj instance
;---------------------------------------------------------------
; Input:
;       ds:si = TDateObj instance address
;       year    (word, on stack)
;       day     (word, on stack)
;       month   (word, on stack)
; Output:
;       arguments stored in TDateObj instance
; Registers:
;       ax
;---------------------------------------------------------------
PROC    TDateObj_setDate  PASCAL
        ARG     @@year:WORD, @@day:WORD, @@month:WORD
        mov     ax, [@@year]
        mov     [(TDateObj PTR si).year], ax
        mov     ax, [@@day]
        mov     [(TDateObj PTR si).day], ax
        mov     ax, [@@month]
        mov     [(TDateObj PTR si).month], al
        ret
ENDP    TDateObj_setDate

;---------------------------------------------------------------
; TDateObj_getDate      Return a TDateObj instance's data
;---------------------------------------------------------------
; Input:
;       ds:si = TDateObj instance address
; Output:
;       ax  = instance.year
;       cx  = instance.day
;       dl  = instance.month       
; Registers:
;       ax, cx, dl       
;---------------------------------------------------------------
PROC    TDateObj_getDate  PASCAL
        mov     ax, [(TDateObj PTR si).year]
        mov     cx, [(TDateObj PTR si).day]
        mov     dl, [(TDateObj PTR si).month]
        ret
ENDP    TDateObj_getDate

;---------------------------------------------------------------
; TDateObj_print       Print item                        VIRTUAL
;---------------------------------------------------------------
; Input:
;       ds:si = TDateObj instance address
; Output:
;       none
; Registers:
;       none
;---------------------------------------------------------------
PROC    TDateObj_print  PASCAL 
        USES    ax, cx, di, es                  ; Preserve registers

        push    ds                              ; Set es equal to ds
        pop     es                              ;  for extrn subroutines
        mov     di, offset TDateObj_msg         ; Address label string
        call    StrWrite                        ; Display string

        mov     ax, [(TDateObj PTR si).day]
        mov     cx, 2
        mov     di, offset dayBuf
        call    BinToAscDec
        
        mov     ah, 0
        mov     al, [(TDateObj PTR si).month]
        mov     cx, 2
        mov     di, offset monthBuf
        call    BinToAscDec

        mov     ax, [(TDateObj PTR si).year]
        mov     cx, 4
        mov     di, offset yearBuf
        call    BinToAscDec

        mov     [daySep], '/'
        mov     [monthSep], '/'
        mov     di, offset dayBuf
        call    StrWrite

        call    NewLine                         ; Start new display line
        ret
ENDP    TDateObj_print
