%TITLE "TASM OOP VMT macros -- by Tom Swan"

;---- Small memory model macros and equates

IF (@CodeSize EQ 0)

    MACRO   VMTSeg           ;; Store VMTs in code segment
    CODESEG
    ENDM    VMTSeg

    @VMTSeg = @code          ;; Equate VMTSeg with code segment name

    MACRO   LoadVMTSeg reg   ;; Prepare VMT segment addressing register
        push    cs           ;; Push code segment onto stack
        pop     reg          ;; Pop cs into desired segment register
    ENDM

    MPtr    EQU     <WORD>   ;; Virtual functions are 16-bit addresses

ELSE

;----- Large and huge memory model macros and equates

    SEGMENT VMT_Seg PUBLIC   ;; Store VMTs in separate data segment
    ENDS    VMT_Seg

    MACRO   VMTSeg
        SEGMENT     VMT_Seg  ;; Use VMTSeg macro to create VMT segment
    ENDM    VMTSeg

    @VMTSeg = VMT_Seg        ;; Equate VMTSeg with our data segment

    MACRO   LoadVMTSeg reg   ;; Prepare VMT segment addressing register
        push    bx           ;; Save register used by macro
        mov     bx, @VMTSeg  ;; Move segment address into bx
        mov     reg, bx      ;; Move bx into desired segment register
        pop     bx           ;; Restore saved bx
    ENDM    LoadVMTSeg

    MPtr    EQU     <DWORD>  ;; Virtual functions are 32-bit addresses

ENDIF

;----- Define Virtual Method Table macro (all memory models)

    MACRO   Make_VMT
        VMTSeg               ;; Start new segment for large & huge models
        TBLINST              ;; Create the virtual method table
        ENDS                 ;; End segment started by VMTSeg macro
        CODESEG              ;; Resume code segment
    ENDM    Make_VMT
