%TITLE "TStrObj object -- by Tom Swan"

GLOBAL TStrObj_construct:PROC
GLOBAL TStrObj_init:PROC
GLOBAL TStrObj_print:PROC

STRUC TStrObj TItem METHOD {
  construct:mptr     = TStrObj_construct  ; TStrObj constructor
  init:mptr          = TStrObj_init       ; TStrObj initializer
  VIRTUAL print:mptr = TStrObj_print      ; Print or display item
}
  data_s        dw      ?                 ; Ptr to null-terminated string
ENDS  TStrObj

Make_VMT        ; Define TStrObj VMT

DATASEG

TStrObj_msg     db      'String item  = ', 0

CODESEG

;-----  From STRIO.OBJ
        EXTRN   NewLine:Proc, StrWrite:Proc

;---------------------------------------------------------------
; TStrObj_construct   TStrObj constructor
;---------------------------------------------------------------
; Input:
;       ds:si = TStrObj instance address
; Output:
;       VMT ptr initialized
; Registers:
;       none
;---------------------------------------------------------------
PROC    TStrObj_construct  PASCAL
        TBLINIT TStrObj PTR si              ; Initialize VMT pointer
        ret
ENDP    TStrObj_construct

;---------------------------------------------------------------
; TStrObj_init        Initialize item "next" pointer
;---------------------------------------------------------------
; Input:
;       ds:si = TStrObj instance address
;       arg   = 16-bit offset to string in data segment
; Output:
;       instance.data_s <- arg
; Registers:
;       none
;---------------------------------------------------------------
PROC    TStrObj_init  PASCAL
        ARG     @@data:word
        USES    ax
        CALL    si METHOD TItem:init            ; Call TItem ancestor init
        mov     ax, [@@data]                    ; Get argument from stack
        mov     [(TStrObj PTR si).data_s], ax   ; Assign arg to instance
        ret
ENDP    TStrObj_init

;---------------------------------------------------------------
; TStrObj_print       Print item                         VIRTUAL
;---------------------------------------------------------------
; Input:
;       ds:si = TStrObj instance address
; Output:
;       none
; Registers:
;       none
;---------------------------------------------------------------
PROC    TStrObj_print  PASCAL 
        USES    di, es                          ; Preserve registers
        push    ds                              ; Set es equal to ds
        pop     es                              ;  for extrn subroutines
        mov     di, offset TStrObj_msg          ; Address label string
        call    StrWrite                        ; Display string
        mov     di, [(TStrObj PTR si).data_s]   ; Get instance string ptr
        call    StrWrite                        ; Display string
        call    NewLine                         ; Start new display line
        ret
ENDP    TStrObj_print
