%TITLE "TList object -- by Tom Swan"

GLOBAL TList_construct:PROC
GLOBAL TList_init:PROC
GLOBAL TList_getCount:PROC
GLOBAL TList_insertItem:PROC
GLOBAL TList_printAll:PROC

STRUC TList METHOD {
  construct:mptr          = TList_construct  ; TList constructor
  init:mptr               = TList_init       ; TList initializer
  getCount:mptr           = TList_getCount   ; Return number of items
  VIRTUAL insertItem:mptr = TList_insertItem ; Insert TItem into list
  VIRTUAL printAll:mptr   = TList_printAll   ; Print or display all items
}
  TBLPTR                                     ; Virtual method table pointer
  root      dw   ?                           ; Ptr to first item in list
  num       dw   ?                           ; Number of listed items
ENDS  TList

Make_VMT        ; Define TList VM

CODESEG

;---------------------------------------------------------------
; TList_construct   TList constructor
;---------------------------------------------------------------
; Input:
;       ds:si = TList instance address
; Output:
;       VMT ptr initialized
; Registers:
;       none
;---------------------------------------------------------------
PROC    TList_construct  PASCAL
        TBLINIT TList PTR si                ; Initialize VMT pointer
        ret
ENDP    TList_construct

;---------------------------------------------------------------
; TList_init        Initialize list to empty state
;---------------------------------------------------------------
; Input:
;       ds:si = TList instance address
; Output:
;       root field <- nil (0000) (empty list)
; Registers:
;       none
;---------------------------------------------------------------
PROC    TList_init  PASCAL 
        mov     [(TList PTR si).root], 0    ; Set root to zero (empty)
        mov     [(TList PTR si).num], 0     ; Set num items to zero
        ret
ENDP    TList_init

;---------------------------------------------------------------
; TList_getCount    Return number of listed items
;---------------------------------------------------------------
; Input:
;       ds:si = TList instance address
; Output:
;       ax = number of items in list
; Registers:
;       ax
;---------------------------------------------------------------
PROC    TList_getCount  PASCAL 
        mov     ax, [(TList PTR si).num]    ; Get num field from list
        ret
ENDP    TList_getCount

;---------------------------------------------------------------
; TList_insertItem  Insert an item into the list         VIRTUAL
;---------------------------------------------------------------
; Input:
;       ds:si = TList instance address
;       arg   = TItem 16-bit address (offset into data segment)
; Output:
;       Item instance linked into list
; Registers:
;       none
;---------------------------------------------------------------
PROC    TList_insertItem  PASCAL 
        ARG     @@item:word                 ; Stack offset to argument
        USES    ax, bx                      ; Preserve ax and bx
        mov     ax, [(TList PTR si).root]   ; Set ax to list root ptr
        mov     bx, [@@item]                ; Set bx to item ptr
        mov     [(TItem PTR bx).next], ax   ; Set item.next = root
        mov     [(TList PTR si).root], bx   ; Set list.root = item ptr
        inc     [(TList PTR si).num]        ; Increment num items
        ret
ENDP    TList_insertItem

;---------------------------------------------------------------
; TList_printAll      Call print for all listed items    VIRTUAL
;---------------------------------------------------------------
; Input:
;       ds:si = TList instance address
; Output:
;       depends on items' print methods
; Registers:
;       none
;---------------------------------------------------------------
PROC    TList_printAll  PASCAL
        USES    si, es                      ; Preserve registers
        LoadVMTSeg es                       ; Initialize es (optional*)
        mov     si, [(TList PTR si).root]   ; Set si to list root ptr
@@10:
        or      si, si                      ; Test si for 0 (nil)
        jz      @@99                        ; Jump to exit if si = 0
        CALL    TItem PTR si METHOD TItem:print  ; Call item's print method!
        mov     si, [(TItem PTR si).next]   ; Set si to next item ptr
        jmp     @@10                        ; Loop until done
@@99:
        ret
ENDP    TList_printAll

; * Optional depending on memory model
