%TITLE "TItem object -- by Tom Swan"

GLOBAL TItem_construct:PROC
GLOBAL TItem_init:PROC
GLOBAL TItem_print:PROC

STRUC TItem METHOD {
  construct:mptr          = TItem_construct  ; TItem constructor
  init:mptr               = TItem_init       ; TItem initializer
  VIRTUAL print:mptr      = TItem_print      ; Print or display item
}
  TBLPTR                                     ; Virtual method table pointer
  next      dw   ?                           ; Pointer to next item
ENDS  TItem

Make_VMT        ; Define TItem VMT

CODESEG

;---------------------------------------------------------------
; TItem_construct   TItem constructor
;---------------------------------------------------------------
; Input:
;       ds:si = TItem instance address
; Output:
;       VMT ptr initialized
; Registers:
;       none
;---------------------------------------------------------------
PROC    TItem_construct  PASCAL
        TBLINIT TItem PTR si                ; Initialize VMT pointer
        ret
ENDP    TItem_construct

;---------------------------------------------------------------
; TItem_init        Initialize item "next" pointer
;---------------------------------------------------------------
; Input:
;       ds:si = TItem instance address
; Output:
;       next field <- nil (0000)
; Registers:
;       none
;---------------------------------------------------------------
PROC    TItem_init  PASCAL 
        mov     [(TItem PTR si).next], 0    ; Set next field to zero
        ret
ENDP    TItem_init

;---------------------------------------------------------------
; TItem_print       Print item                           VIRTUAL
;---------------------------------------------------------------
; Input:
;       ds:si = TItem instance address
; Output:
;       none
; Registers:
;       none
;---------------------------------------------------------------
PROC    TItem_print  PASCAL 
        ret                     ; Instructions supplied by actual items
ENDP    TItem_print
