%TITLE "TIntObj object -- by Tom Swan"

GLOBAL TIntObj_construct:PROC
GLOBAL TIntObj_init:PROC
GLOBAL TIntObj_print:PROC

STRUC TIntObj TItem METHOD {
  construct:mptr     = TIntObj_construct  ; TIntObj constructor
  init:mptr          = TIntObj_init       ; TIntObj initializer
  VIRTUAL print:mptr = TIntObj_print      ; Print or display item
}
  data_i        dw      ?                 ; 16-bit integer data
ENDS  TIntObj

Make_VMT        ; Define TIntObj VMT

DATASEG

TIntObj_buffer  db      20 DUP (0)
TIntObj_msg     db      'Integer item = ', 0

CODESEG

;-----  From BINASC.OBJ, STRIO.OBJ
        EXTRN   BinToAscHex:Proc, NewLine:Proc, StrWrite:Proc

;---------------------------------------------------------------
; TIntObj_construct   TIntObj constructor
;---------------------------------------------------------------
; Input:
;       ds:si = TIntObj instance address
; Output:
;       VMT ptr initialized
; Registers:
;       none
;---------------------------------------------------------------
PROC    TIntObj_construct  PASCAL
        TBLINIT TIntObj PTR si              ; Initialize VMT pointer
        ret
ENDP    TIntObj_construct

;---------------------------------------------------------------
; TIntObj_init        Initialize item "next" pointer
;---------------------------------------------------------------
; Input:
;       ds:si = TIntObj instance address
;       arg   = 16-bit integer to store in instance
; Output:
;       instance.data_i <- arg
; Registers:
;       none
;---------------------------------------------------------------
PROC    TIntObj_init  PASCAL
        ARG     @@data:word
        USES    ax
        CALL    si METHOD TItem:init            ; Call TItem ancestor init
        mov     ax, [@@data]                    ; Get argument from stack
        mov     [(TIntObj PTR si).data_i], ax   ; Assign arg to instance
        ret
ENDP    TIntObj_init

;---------------------------------------------------------------
; TIntObj_print       Print item                           VIRTUAL
;---------------------------------------------------------------
; Input:
;       ds:si = TIntObj instance address
; Output:
;       none
; Registers:
;       none
;---------------------------------------------------------------
PROC    TIntObj_print  PASCAL 
        USES    ax, cx, di, es                  ; Preserve registers
        push    ds                              ; Set es equal to ds
        pop     es                              ;  for extrn subroutines
        mov     di, offset TIntObj_msg          ; Address label string
        call    StrWrite                        ; Display string
        mov     ax, [(TIntObj PTR si).data_i]   ; Get instance integer data
        mov     cx, 1                           ; Minimum digits to output
        mov     di, offset TIntObj_buffer       ; Address working string
        call    BinToAscHex                     ; Convert integer to string
        call    StrWrite                        ; Display string
        call    NewLine                         ; Start new display line
        ret
ENDP    TIntObj_print
