%TITLE "List object demonstration -- by Tom Swan"

        IDEAL

        JUMPS

        LOCALS @@

        MODEL small, PASCAL

        STACK 1000H

        INCLUDE "..\oomacros.inc"

        INCLUDE "titem.inc"

        INCLUDE "tlist.inc"

        INCLUDE "tintobj.inc"

        INCLUDE "tstrobj.inc"

        DATASEG

exCode  db      0               ; Program exit code

;----- Define list instance

list    TList   <>

;----- Define integer item instances

i1      TIntObj <>
i2      TIntObj <>
i3      TIntObj <>

;----- Define string item instances

s1      TStrObj <>
s2      TStrObj <>

;----- Define static strings for string instances

str1    db      'Some colors: Red, White, Blue', 0
str2    db      'Some days: Monday, Tuesday, Friday', 0

;----- Define various program strings

str3    db      'After initializing list...', 0
str4    db      'After inserting integer items...', 0
str5    db      'After inserting string items...', 0
strNum  db      'Number of items in list = ', 0
strBuf  db      20 DUP (0)

        CODESEG

;-----  From BINASC.OBJ, STRIO.OBJ
        EXTRN   BinToAscDec:Proc, NewLine:Proc, StrWrite:Proc

Start:  
        mov     ax, @data       ; Initialize DS to address
        mov     ds, ax          ;  of data segment

;----- Initialize the list instance

        mov     si, offset list
        LoadVMTSeg es
        CALL    si METHOD TList:construct
        CALL    si METHOD TList:init

        mov     di, offset str3
        call    DisplayItems

;----- Initialize integer item instances

        mov     si, offset i1
        LoadVMTSeg es
        CALL    si METHOD TIntObj:construct
        CALL    si METHOD TIntObj:init, 01h

        mov     si, offset i2
        LoadVMTSeg es
        CALL    si METHOD TIntObj:construct
        CALL    si METHOD TIntObj:init, 02h

        mov     si, offset i3
        LoadVMTSeg es
        CALL    si METHOD TIntObj:construct
        CALL    si METHOD TIntObj:init, 03h

;----- Initialize string item intances

        mov     si, offset s1
        LoadVMTSeg es
        CALL    si METHOD TStrObj:construct
        CALL    si METHOD TStrObj:init, offset str1

        mov     si, offset s2
        LoadVMTSeg es
        CALL    si METHOD TStrObj:construct
        CALL    si METHOD TStrObj:init, offset str2

;----- Insert integer item instances into list

        mov     si, offset list
        LoadVMTSeg es
        mov     ax, offset i1
        call    InsertItem
        mov     ax, offset i2
        call    InsertItem
        mov     ax, offset i3
        call    InsertItem

        mov     di, offset str4
        call    DisplayItems

;----- Insert string item instances into list

        mov     ax, offset s1
        call    InsertItem
        mov     ax, offset s2
        call    InsertItem

        mov     di, offset str5
        call    DisplayItems

Exit:
        mov     ah, 04Ch        ; DOS function: Exit program
        mov     al, [exCode]    ; Return exit code value
        int     21h             ; Call DOS.  Terminate program

;---------------------------------------------------------------
; InsertItem            Insert object instance into list
;---------------------------------------------------------------
; Input:
;       ax = offset to instance in data segment
; Output:
;       none
; Registers:
;       si
;---------------------------------------------------------------
PROC    InsertItem      PASCAL
        mov     si, offset list
        LoadVMTSeg es
        CALL    TList PTR si METHOD TList:insertItem, ax
        ret
ENDP    InsertItem

;---------------------------------------------------------------
; DisplayItems          Display all listed items
;---------------------------------------------------------------
; Input:
;       di = address of string message
; Output:
;       none
; Registers:
;       none
;---------------------------------------------------------------
PROC    DisplayItems PASCAL
        USES    es

        mov     si, offset list           ; Address list instance
        LoadVMTSeg es                     ; Prepare es register
        CALL    si METHOD TList:getCount  ; Get num items in list
        push    ax                        ; Save result on stack

        push    ds                        ; Make es = ds for 
        pop     es                        ;  extrn subroutines
        call    NewLine                   ; Start new display line
        call    StrWrite                  ; Display message at di
        call    NewLine                   ; Start new display line

        mov     di, offset strNum         ; Address num items label
        call    StrWrite                  ; Display label

        pop     ax                        ; Get number of listed items 
        mov     cx, 1                     ; Minimum digits to output
        mov     di, offset strBuf         ; Address working string
        call    BinToAscDec               ; Convert integer to string
        call    StrWrite                  ; Display string
        call    NewLine                   ; Start new display line

        mov     si, offset list           ; Address list instance
        LoadVMTSeg es                     ; Prepare es register
        CALL    TList PTR si METHOD TList:printAll  ; Display all items
        ret
ENDP    DisplayItems

        END     Start           ; End of program / entry point

