%TITLE "TDerived object -- by Tom Swan"

GLOBAL TDerived_init:PROC
GLOBAL TDerived_getData:PROC

STRUC TDerived TBase METHOD {       ; Declare derived object from base
  init:dword = TDerived_init        ; TDerived object method
  getData:dword = TDerived_getData  ; TDerived object method
}                                   ; End of object methods
  TDerived_data  dw      ?          ; TDerived object data
ENDS TDerived                       ; End of derived object

CODESEG

;---------------------------------------------------------------
; TDerived_init         TDerived init method 
;---------------------------------------------------------------
; Input:
;       ds:si = instance address
;       arg1 = word to store in base instance data
;       arg2 = word to store in derived instance data
; Output:
;       arg1 -> instance.TBase_data
;       arg2 -> instance.TDerived_data
; Registers:
;       none
;---------------------------------------------------------------
PROC    TDerived_init PASCAL
        ARG     @@data1:word, \
                @@data2:word
        USES    ax
        mov     ax, [@@data1]               ; Move arg1 into ax *
        CALL    si METHOD TBase:init, ax    ; Call base init method *
        mov     ax, [@@data2]               ; Move arg2 into ax
        mov     [(TDerived PTR si).TDerived_data], ax  ; Store in instance
        ret
ENDP    TDerived_init

; ----- * These mov and call statements can also be written as:
;       CALL    si METHOD TBase:init, [@@data1]

;---------------------------------------------------------------
; TDerived_getData      TDerived getData method
;---------------------------------------------------------------
; Input:
;       ds:si = instance address
; Output:
;       ax = instance.TBase_data
;       dx = instance.TDerived_data
; Registers:
;       ax, dx
;---------------------------------------------------------------
PROC    TDerived_getData  PASCAL 
        CALL    si METHOD TBase:getData                ; ax <- base data
        mov     dx, [(TDerived PTR si).TDerived_data]  ; dx <- derived data
        ret
ENDP    TDerived_getData
