%TITLE "TBase object -- by Tom Swan"

GLOBAL TBase_init:PROC
GLOBAL TBase_getData:PROC

STRUC TBase METHOD {            ; Declare base object
  init:dword = TBase_init       ; TBase object method
  getData:dword = TBase_getData ; TBase object method
}                               ; End of object methods
  TBase_data     dw      ?      ; TBase object data
ENDS  TBase                     ; End of base object

CODESEG

;---------------------------------------------------------------
; TBase_init        TBase init method 
;---------------------------------------------------------------
; Input:
;       ds:si = instance address
;       arg1 = word to store in instance
; Output:
;       arg1 -> instance.TBase_data
; Registers:
;       none
;---------------------------------------------------------------
PROC    TBase_init  PASCAL 
        ARG     @@data:word         ; Create offset to argument on stack
        USES    ax                  ; Preserve ax register (optional)
        mov     ax, [@@data]        ; Move argument into ax
        mov     [(TBase PTR si).TBase_data], ax     ; Save ax in instance
        ret
ENDP    TBase_init

;---------------------------------------------------------------
; TBase_getData     TBase getData method
;---------------------------------------------------------------
; Input:
;       ds:si = instance address
; Output:
;       ax = instance.TBase_data
; Registers:
;       ax
;---------------------------------------------------------------
PROC    TBase_getData  PASCAL 
        mov     ax, [(TBase PTR si).TBase_data]  ; ax <- base data
        ret
ENDP    TBase_getData
