%TITLE "TPoint object -- by Tom Swan"

GLOBAL TPoint_getx:PROC
GLOBAL TPoint_gety:PROC
GLOBAL TPoint_setx:PROC
GLOBAL TPoint_sety:PROC

STRUC TPoint METHOD {           ; Begin TPoint object declaration
  getx:dword = TPoint_getx      ; Return object's x data
  gety:dword = TPoint_gety      ; Return object's y data
  setx:dword = TPoint_setx      ; Change object's x data
  sety:dword = TPoint_sety      ; Change object's y data
  }                             ; End of method declarations
  x  dw  ?                      ; Object's x data
  y  dw  ?                      ; Object's y data
ENDS  TPoint                    ; End TPoint object declaration

CODESEG

%NEWPAGE
;---------------------------------------------------------------
; TPoint_getx           TPoint getx method 
;---------------------------------------------------------------
; Input:
;       ds:si = instance address
; Output:
;       ax = instance.x data
; Registers:
;       ax
;---------------------------------------------------------------
PROC    TPoint_getx PASCAL
        mov     ax, [(TPoint PTR si).x] ; Move instance x data into ax
        ret                             ; Return to caller
ENDP    TPoint_getx
%NEWPAGE
;---------------------------------------------------------------
; TPoint_gety           TPoint gety method
;---------------------------------------------------------------
; Input:
;       ds:si = instance address
; Output:
;       ax = instance.y data
; Registers:
;       ax
;---------------------------------------------------------------
PROC    TPoint_gety PASCAL
        mov     ax, [(TPoint PTR si).y] ; Move instance y data into ax
        ret                             ; Return to caller
ENDP    TPoint_gety
%NEWPAGE
;---------------------------------------------------------------
; TPoint_setx           TPoint setx method
;---------------------------------------------------------------
; Input:
;       ds:si = instance address
;       x (word) parameter
; Output:
;       none
; Registers:
;       ax
;---------------------------------------------------------------
PROC    TPoint_setx PASCAL
        ARG     @@x:word                ; Create stack offset to param x
        USES    ax                      ; Preserve ax (optional)
        mov     ax, [@@x]               ; Move x param into ax
        mov     [(TPoint PTR si).x], ax ; Move x param into instance.x
        ret                             ; Return to caller
ENDP    TPoint_setx
%NEWPAGE
;---------------------------------------------------------------
; TPoint_sety           TPoint sety method
;---------------------------------------------------------------
; Input:
;       ds:si = instance address
;       y (word) parameter
; Output:
;       none
; Registers:
;       ax
;---------------------------------------------------------------
PROC    TPoint_sety PASCAL
        ARG     @@y:word                ; Create stack offset to param y
        USES    ax                      ; Preserve ax (optional)
        mov     ax, [@@y]               ; Move y param into ax
        mov     [(TPoint PTR si).y], ax ; Move y param into instance.y
        ret                             ; Return to caller
ENDP    TPoint_sety
