%TITLE "TPoint object demonstration -- by Tom Swan"

        IDEAL                   ; Select Ideal mode syntax     

        JUMPS                   ; Enable auto-conditional jumps

        LOCALS  @@              ; Enable block-scoped labels

        MODEL   large, PASCAL   ; Select a memory model and language

        STACK   1000h           ; Allocate program stack

        INCLUDE "tpoint.inc"    ; Include TPoint object module

        DATASEG                 ; Start of data segment

exCode  DB      0               ; Program exit code

;----- Define TPoint instances

p1      TPoint  <>              ; Default TPoint instance
p2      TPoint  <01h, 02h>      ; Initialized TPoint instance

        CODESEG                 ; Start of code segment

Start:  
        mov     ax, @data       ; Initialize DS to address
        mov     ds, ax          ;  of data segment

;----- Call TPoint methods

        mov     si, offset p1               ; Address instance with ds:si
        CALL    si METHOD TPoint:getx       ; Call object method

        mov     si, offset p2               ; Address instance with ds:si
        CALL    si METHOD TPoint:gety       ; Call object method

;----- Pass literal arguments to methods

        mov     si, offset p1               ; Address instance with ds:si
        CALL    si METHOD TPoint:setx, 03h  ; Pass argument to method

        mov     si, offset p1               ; Address instance with ds:si
        CALL    si METHOD TPoint:sety, 04h  ; Pass argument to method

;----- Pass register arguments to methods

        mov     si, offset p2               ; Address instance with ds:si
        mov     dx, 05h                     ; Load argument into dx
        CALL    si METHOD TPoint:setx, dx   ; Pass dx on stack to method

        mov     si, offset p2               ; Address instance with ds:si
        mov     cx, 06h                     ; Load argument into cx
        CALL    si METHOD TPoint:sety, cx   ; Pass cx on stack to method

Exit:
        mov     ah, 04Ch        ; DOS function: Exit program
        mov     al, [exCode]    ; Return exit code value
        int     21h             ; Call DOS.  Terminate program

        END     Start           ; End of program / entry point
