#-----------------------------------------------------------------------------
#                    MASTERING TURBO ASSEMBLER 2nd Ed.
#                              by Tom Swan
#
#       To compile the Pascal programs, enter this DOS command:
#
#               MAKE -fMAKEPAS.MAK
#
#       Be sure to use Borland's MAKE utility--other similar
#       MAKEs may not work correctly.  Read the notes below to modify
#       this file for compiling programs to run with Turbo Debugger
#       or to compile without adding debugging information to the
#       disk files.  Look for sections that begin with "# OPTION:"
#       Also examine the MAKEASM.MAK and MAKEC.MAK files, which
#       compile the Turbo Assembler and C/C++ sample programs.
#
#       Copyright (c) 1989,1995 by Tom Swan. All rights reserved.
#-----------------------------------------------------------------------------

# Specify the name of your Pascal compiler here. Use tpc for Turbo
# Pascal; use bpc for Borland Pascal.

compiler = bpc

# OPTION:
# To examine programs with Turbo Debugger, leave the following line
# as is.  To assemble without debugging information (which will save
# lots of disk space), delete the following line or insert a # in 
# column one, converting the line to a comment:

debugging = 1

# Note: If you change the debugging symbol, delete all .OBJ, .COM, 
# and .EXE files before remaking.


# These statements create appropriate macros based on the
# setting of the debugging symbol above.  The /zi option adds
# debugging information to assembled .OBJ files.  The /v option
# adds debugging information to compiled .EXE files.

!if $d(debugging)
assemble=tasm /zi
compile=$(compiler) /v
!else
assemble=tasm
compile=$(compiler)
!endif


#-----  Force MAKE to recognize various dependencies

depends: pasdemo.exe fillstr.exe strslow.exe str.exe passhell.obj



#-----  Compile and assemble

pasdemo.exe: pasdemo.obj pasdemo.pas
   $(compile) pasdemo

pasdemo.obj: pasdemo.asm
   $(assemble) pasdemo

passhell.obj: passhell.asm
   $(assemble) passhell

fillstr.exe: fillstr.obj fillstr.pas
   $(compile) fillstr

fillstr.obj: fillstr.asm
   $(assemble) fillstr

str.exe: str.obj str.pas
   $(compile) str

str.obj: str.asm
   $(assemble) str

strslow.exe: strslow.pas
   $(compile) strslow

