#-----------------------------------------------------------------------------
#                    MASTERING TURBO ASSEMBLER 2nd Ed.
#                              by Tom Swan
#
#       To compile the example C/C++ programs, enter this DOS command:
#
#               MAKE -fMAKEC.MAK
#
#       Be sure to use Borland's MAKE utility--other similar
#       MAKEs may not work correctly.  Read the notes below to modify
#       this file for compiling programs to run with Turbo Debugger
#       or to compile without adding debugging information to the
#       disk files.  Look for sections that begin with "# OPTION:"
#       Also examine the MAKEASM.MAK and MAKEPAS.MAK files, which
#       compile the Turbo Assembler and Pascal sample programs.
#
#       Copyright (c) 1989,1995 by Tom Swan. All rights reserved.
#-----------------------------------------------------------------------------

# Specify the name of your C compiler here. Use tcc for Turbo C or 
# Turbo C++; use bcc for Borland C++.

compiler = bcc

# OPTION:
# To examine programs with Turbo Debugger, leave the following line
# as is.  To assemble without debugging information (which will save
# lots of disk space), delete the following line or insert a # in 
# column one, converting the line to a comment:

debugging = 1

# Note: If you change the debugging symbol, delete all .OBJ, .COM, 
# and .EXE files before remaking.


# These statements create appropriate macros based on the
# setting of the debugging symbol above.  The /zi option adds
# debugging information to assembled .OBJ files.  The /ml option
# switches on case sensitivity.  The -v option adds debugging
# information to compiled .OBJ files.  The -ms option specifies
# the small memory model (external modules only).  The -lv option
# passes the -v debugging option to Turbo Linker, using TCC as
# a "front end" to drive the linker.  The -c option specifies
# compile only.  The -B option compiles via inline assembly.
                              
!if $d(debugging)
assemble=tasm /ml /zi
inlinecomp=$(compiler) -B -v
externcomp=$(compiler) -c -v
externlink=$(compiler) -ms -lv 
!else
assemble=tasm /ml
inlinecomp=$(compiler) -B
externcomp=$(compiler) -c
externlink=$(compiler) -ms -l
!endif



#-----  Force MAKE to recognize various dependencies

depends: tally.exe updown.exe cflags.exe cshell.obj cfillstr.exe



#-----  Compile, assemble, and link 

tally.exe: tally.c
   $(inlinecomp) tally.c

updown.exe: updown.c
   $(inlinecomp) updown.c 

cflags.exe: cflags.c
   $(inlinecomp) cflags.c

cshell.obj: cshell.asm
   $(assemble) cshell

cfillstr.exe: cfill.obj cfillstr.c
   $(externcomp) cfillstr.c
   $(externlink) cfillstr.obj cfill.obj

cfill.obj: cfill.asm
   $(assemble) cfill   

