#-----------------------------------------------------------------------------
#                    MASTERING TURBO ASSEMBLER 2nd Ed.
#                              by Tom Swan
#
#       To assemble all programs, link executable code files, and
#       install separate modules in MTA.LIB, enter this DOS command:
#
#               MAKE -fMAKEASM.MAK
#
#       Or, for easier assembling and linking, copy this file to a new
#       file named MAKEFILE (no extension). You can then simply type 
#       MAKE to assemble:
#
#               MAKE
#
#       Be sure to use Borland's MAKE utility program--other similar
#       MAKEs may not work correctly.  Read the notes below to modify
#       this file for assembling programs to run with Turbo Debugger
#       or to assemble without adding debugging information to the
#       disk files.  You can also specify an object-code library 
#       file name.  Look for sections that begin with "# OPTION:"
#       Also examine the MAKEPAS.MAK and MAKEC.MAK files, which
#       compile the Pascal and C/C++ sample programs.
#
#       Copyright (c) 1989,1995 by Tom Swan. All rights reserved.
#-----------------------------------------------------------------------------


# OPTION:
# To examine programs with Turbo Debugger, leave the following line
# as is.  To assemble without debugging information (which will save
# lots of disk space), delete the following line or insert a # in 
# column one, converting the line to a comment:

debugging = 1

# Note: If you change the debugging symbol, delete all .OBJ, .COM, 
# and .EXE files before remaking.


# OPTION:
# Normally, assembled .OBJ modules such as STRINGS and ASYNCH are
# installed in the library file MTA.LIB.  You can specify a different
# library file by changing MTA.LIB in the following line.  You may
# also specify disk drive and a path name as in c:\tasm\lib\mta.lib.

library = MTA.LIB


# These statements create appropriate macros based on the
# setting of the debugging symbol above.  The /zi option adds
# debugging information to assembled .OBJ files.  The /v option
# adds debugging information to linked .EXE and .COM files.
# The /x option prevents .MAP files from being created, which
# saves a little disk space.

!if $d(debugging)
assemble=tasm /zi
link=tlink /v /x
!else
assemble=tasm
link=tlink /x
!endif


#-----  Force MAKE to recognize various dependencies

depends: asynch.obj bcd.obj binasc.obj datetime.obj diskerr.obj \
         keyboard.obj params.obj screen.obj strings.obj strio.obj \
         addhex.obj addsub.obj andorxor.obj bound286.obj boxchar.obj \
         cfill.obj chars.obj coldboot.obj comshell.obj convert.obj \
         copystr.obj cshell.obj div286.obj div86.obj divfault.obj \
         dr.obj dt.obj echostr.obj equip.obj exeshell.obj \
         ff.obj fillstr.obj filter.obj hardshel.obj keys.obj kopy.obj \
         lc.obj lf.obj mov.obj muldiv.obj pasdemo.obj passhell.obj \
         pr132.obj pushpop.obj reboot.obj shift.obj showparm.obj \
         single.obj slowmo.obj str.obj struc.obj subdemo.obj \
         table.obj trm.obj upcase.obj version.obj \
         addhex.exe addsub.exe andorxor.exe bound286.exe boxchar.exe \
         chars.exe coldboot.exe comshell.com convert.exe div286.com \
         div86.com divfault.exe dr.exe dt.exe echostr.exe equip.exe \
         exeshell.exe ff.exe filter.exe hardshel.exe keys.exe kopy.exe \
         lc.exe lf.exe mov.exe muldiv.exe pr132.exe pushpop.exe reboot.exe \
         shift.exe showparm.exe single.exe slowmo.exe struc.exe \
         subdemo.exe table.exe trm.exe upcase.exe version.exe \
         capslock.obj capslock.exe \


#----- Create libfiles macro listing all objs in mta.lib

libfiles = asynch.obj bcd.obj binasc.obj datetime.obj diskerr.obj \
           keyboard.obj params.obj screen.obj strings.obj strio.obj


#----- Create mta.lib (type make mta.lib to rebuild mta.lib)

$(library): $(libfiles) 
 tlib $(library) /E -+asynch
 tlib $(library) /E -+bcd
 tlib $(library) /E -+binasc
 tlib $(library) /E -+datetime
 tlib $(library) /E -+diskerr
 tlib $(library) /E -+keyboard
 tlib $(library) /E -+params
 tlib $(library) /E -+screen
 tlib $(library) /E -+strings
 tlib $(library) /E -+strio


#----- Assemble library modules and install or replace in MTA.LIB

asynch.obj: asynch.asm
 $(assemble) asynch
 tlib $(library) /E -+asynch

bcd.obj: bcd.asm
 $(assemble) bcd
 tlib $(library) /E -+bcd

binasc.obj: binasc.asm
 $(assemble) binasc
 tlib $(library) /E -+binasc

datetime.obj: datetime.asm
 $(assemble) datetime
 tlib $(library) /E -+datetime

diskerr.obj: diskerr.asm
 $(assemble) diskerr
 tlib $(library) /E -+diskerr

keyboard.obj: keyboard.asm
 $(assemble) keyboard
 tlib $(library) /E -+keyboard

params.obj: params.asm
 $(assemble) params
 tlib $(library) /E -+params

screen.obj: screen.asm
 $(assemble) screen
 tlib $(library) /E -+screen

strings.obj: strings.asm
 $(assemble) strings
 tlib $(library) /E -+strings

strio.obj: strio.asm
 $(assemble) strio
 tlib $(library) /E -+strio


#----- Assemble executable programs and other modules

addhex.obj: addhex.asm
 $(assemble) addhex

addsub.obj: addsub.asm
 $(assemble) addsub

andorxor.obj: andorxor.asm
 $(assemble) andorxor

bound286.obj: bound286.asm
 $(assemble) bound286

boxchar.obj: boxchar.asm
 $(assemble) boxchar

capslock.obj: capslock.asm
 $(assemble) capslock

cfill.obj: cfill.asm
 $(assemble) /ml cfill

chars.obj: chars.asm
 $(assemble) chars

coldboot.obj: coldboot.asm
 $(assemble) coldboot

comshell.obj: comshell.asm
 $(assemble) comshell

convert.obj: convert.asm
 $(assemble) convert

copystr.obj: copystr.asm
 $(assemble) copystr

cshell.obj: cshell.asm
 $(assemble) cshell

div286.obj: div286.asm
 $(assemble) div286

div86.obj: div86.asm
 $(assemble) div86

divfault.obj: divfault.asm
 $(assemble) divfault

dr.obj: dr.asm
 $(assemble) dr

dt.obj: dt.asm
 $(assemble) dt

echostr.obj: echostr.asm
 $(assemble) echostr

equip.obj: equip.asm
 $(assemble) equip

exeshell.obj: exeshell.asm
 $(assemble) exeshell

ff.obj: ff.asm
 $(assemble) ff

fillstr.obj: fillstr.asm
 $(assemble) fillstr

filter.obj: filter.asm
 $(assemble) filter

hardshel.obj: hardshel.asm
 $(assemble) hardshel

keys.obj: keys.asm
 $(assemble) keys

kopy.obj: kopy.asm
 $(assemble) kopy

lc.obj: lc.asm
 $(assemble) lc

lf.obj: lf.asm
 $(assemble) lf

mov.obj: mov.asm
 $(assemble) mov

muldiv.obj: muldiv.asm
 $(assemble) muldiv

pasdemo.obj: pasdemo.asm
 $(assemble) pasdemo

passhell.obj: passhell.asm
 $(assemble) passhell

pr132.obj: pr132.asm
 $(assemble) pr132

pushpop.obj: pushpop.asm
 $(assemble) pushpop

reboot.obj: reboot.asm
 $(assemble) reboot

shift.obj: shift.asm
 $(assemble) shift

showparm.obj: showparm.asm
 $(assemble) showparm

single.obj: single.asm
 $(assemble) single

slowmo.obj: slowmo.asm
 $(assemble) slowmo

str.obj: str.asm
 $(assemble) str

struc.obj: struc.asm
 $(assemble) struc

subdemo.obj: subdemo.asm
 $(assemble) subdemo

table.obj: table.asm
 $(assemble) table

trm.obj: trm.asm
 $(assemble) trm

upcase.obj: upcase.asm
 $(assemble) upcase

version.obj: version.asm
 $(assemble) version


#----- Link program .OBJ files to .EXE files

addhex.exe: addhex.obj screen.obj strings.obj strio.obj
 $(link) addhex,,, $(library)

addsub.exe: addsub.obj
 $(link) addsub,,, $(library)

andorxor.exe: andorxor.obj
 $(link) andorxor,,, $(library)

bound286.exe: bound286.obj strio.obj
 $(link) bound286,,, $(library)

boxchar.exe: boxchar.obj
 $(link) boxchar,,, $(library)

capslock.exe: capslock.obj screen.obj strings.obj strio.obj
 $(link) capslock,,, $(library)

chars.exe: chars.obj screen.obj strings.obj strio.obj
 $(link) chars,,, $(library)

coldboot.exe: coldboot.obj
 $(link) coldboot

comshell.com: comshell.obj
 tlink /t /x comshell,,, $(library)

convert.exe: convert.obj binasc.obj strings.obj strio.obj
 $(link) convert,,, $(library)

div286.com: div286.obj
 tlink /t /x div286,,, $(library)

div86.com: div86.obj
 tlink /t /x div86,,, $(library)

divfault.exe: divfault.obj strio.obj
 $(link) divfault,,, $(library)

dr.exe: dr.obj params.obj strings.obj strio.obj
 $(link) dr,,, $(library)

dt.exe: dt.obj datetime.obj strings.obj strio.obj
 $(link) dt,,, $(library)

echostr.exe: echostr.obj keyboard.obj strio.obj
 $(link) echostr,,, $(library)

equip.exe: equip.obj binasc.obj strio.obj
 $(link) equip,,, $(library)

exeshell.exe: exeshell.obj
 $(link) exeshell,,, $(library)

ff.exe: ff.obj
 $(link) ff,,, $(library)

filter.exe: filter.obj
 $(link) filter,,, $(library)

hardshel.exe: hardshel.obj
 $(link) hardshel,,, $(library)

keys.exe: keys.obj binasc.obj keyboard.obj strio.obj
 $(link) keys,,, $(library)

kopy.exe: kopy.obj diskerr.obj params.obj strio.obj
 $(link) kopy,,, $(library)

lc.exe: lc.obj
 $(link) lc,,, $(library)

lf.exe: lf.obj
 $(link) lf,,, $(library)

mov.exe: mov.obj
 $(link) mov,,, $(library)

muldiv.exe: muldiv.obj
 $(link) muldiv,,, $(library)

pr132.exe: pr132.obj
 $(link) pr132,,, $(library)

pushpop.exe: pushpop.obj
 $(link) pushpop,,, $(library)

reboot.exe: reboot.obj
 $(link) reboot

shift.exe: shift.obj
 $(link) shift,,, $(library)

showparm.exe: showparm.obj binasc.obj params.obj strings.obj strio.obj
 $(link) showparm,,, $(library)

single.exe: single.obj binasc.obj keyboard.obj strio.obj
 $(link) single,,, $(library)

slowmo.exe: slowmo.obj keyboard.obj strio.obj
 $(link) slowmo,,, $(library)

struc.exe: struc.obj
 $(link) struc,,, $(library)

subdemo.exe: subdemo.obj
 $(link) subdemo,,, $(library)

table.exe: table.obj
 $(link) table,,, $(library)

trm.exe: trm.obj asynch.obj binasc.obj keyboard.obj strio.obj
 $(link) trm,,, $(library)

upcase.exe: upcase.obj diskerr.obj params.obj strio.obj
 $(link) upcase,,, $(library)

version.exe: version.obj strio.obj
 $(link) version,,, $(library)


#----- Delete extraneous files (type make clean to use)
clean:
 if exist *.bak del *.bak
 if exist *.map del *.map
