%TITLE "Filter Shell -- Copyright (c) 1989,1995 by Tom Swan"

        IDEAL

        MODEL   small
        STACK   256


;-----  Equates

InputHandle     EQU     0               ; Standard input handle
OutputHandle    EQU     1               ; Standard output handle
ErrOutHandle    EQU     2               ; Standard error-out handle
bell            EQU     07              ; ASCII bell
cr              EQU     13              ; ASCII carriage return
lf              EQU     10              ; ASCII line feed
eof             EQU     26              ; DOS end-of-file char (^Z)


        DATASEG

exCode          DB      0               ; I/O error code


;-----  Error messages

errMessage      DB      bell, cr, lf, 'FILTER ERROR: '
lenErrMessage   =       $-errMessage

codeAccess      EQU     5
errAccess       DB      'access denied', cr, lf
lenErrAccess    =       $-errAccess

codeNotOpen     EQU     6
errNotOpen      DB      'bad handle or file not open', cr, lf
lenErrNotOpen   =       $-errNotOpen

codeDiskFull    EQU     29
errDiskFull     DB      'disk full', cr, lf
lenErrDiskFull  =       $-errDiskFull

errGeneral      DB      'unknown cause', cr, lf  ; Code = ?
lenErrGeneral   =       $-errGeneral


;-----  Input buffer

oneChar         DB      ?       ; Holds one input character


        CODESEG

Start:  
        mov     ax, @data               ; Initialize DS to address
        mov     ds, ax                  ;  of data segment
        mov     es, ax                  ; Make es = ds (optional)

Repeat:
        call    ReadChar                ; Read next character
        jz      Done                    ; End loop if at end-of-file

        mov     al, [oneChar]           ; Load al with input char
        cmp     al, 'A'                 ; Test if > 'A'
        jb      @@10                    ; Jump if al < 'A'
        cmp     al, 'Z'                 ; Test if < 'Z'
        ja      @@10                    ; Jump if al > 'Z'
        add     al, 'a'-'A'             ; Convert A-Z to a-z
        mov     [oneChar], al           ; Save converted character
@@10:

        call    WriteChar               ; Write processed character
        jnz     Repeat                  ; Repeat unless disk is full
        mov     [exCode], codeDiskFull  ; Set error code
        jmp     Exit                    ;  and skip eof write
Done:
        mov     [oneChar], eof          ; Write end-of-file character
        call    WriteChar               ;  to standard output.  Do NOT
                                        ;  check for disk full here!
Exit:
        cmp     [exCode], 0             ; Check for possible error
        jz      @@99                    ; Jump if no error detected
        call    DisplayError            ;  else display error message
@@99:
        mov     ah, 04Ch                ; DOS function: Exit program
        mov     al, [exCode]            ; Return exit code value
        int     21h                     ; Call DOS. Terminate program

%NEWPAGE
;---------------------------------------------------------------
; ReadChar      Read one character from standard input
;---------------------------------------------------------------
; Input:
;       none
; Output:
;       zf = 0 : al = next input character (0..255)
;       zf = 1 : no more input available
; Registers:
;       ax
;---------------------------------------------------------------
PROC    ReadChar
        push    bx                      ; Save modified registers
        push    cx
        push    dx

        mov     ah, 03Fh                ; Read-device function number
        mov     bx, InputHandle         ; Specify input handle
        mov     cx, 1                   ; Number of chars to read
        mov     dx, offset oneChar      ; Store input at ds:dx
        int     21h                     ; Call DOS.  Get input.
        jnc     @@10                    ; Jump if no error indicated
        mov     [exCode], al            ;  else save error code
        jmp     Exit                    ;  and exit program early
@@10:
        or      ax, ax                  ; Set/clear zero flag (zf)

        pop     dx                      ; Restore registers
        pop     cx
        pop     bx
        ret                             ; Return to caller
ENDP    ReadChar
%NEWPAGE
;---------------------------------------------------------------
; WriteChar     Write one character to standard output
;---------------------------------------------------------------
; Input:
;       [oneChar] = character to write
; Output:
;       zf = 0 : character written to standard output file
;       zf = 1 : output device is full (disk output only)
; Registers:
;       ax
;---------------------------------------------------------------
PROC    WriteChar
        push    bx                      ; Save modified registers
        push    cx
        push    dx

        mov     ah, 040h                ; Write-device function number
        mov     bx, OutputHandle        ; Specify output handle
        mov     cx, 1                   ; Number of chars to write
        mov     dx, offset oneChar      ; Take input from ds:dx
        int     21h                     ; Call DOS.  Write output.
        jnc     @@10                    ; Jump if no error detected
        mov     [exCode], al            ;  else save error code
        jmp     Exit                    ;  and exit program early
@@10:
        or      ax, ax                  ; Set/clear zero flag (zf)

        pop     dx                      ; Restore registers
        pop     cx
        pop     bx
        ret                             ; Return to caller
ENDP    WriteChar
%NEWPAGE
;---------------------------------------------------------------
; DisplayError          Display error message
;---------------------------------------------------------------
; Input:
;       [exCode] = non-zero error code
; Output:
;       none: error message sent to standard error-output device
; Registers:
;       ax, bx, cx, dx
;---------------------------------------------------------------
PROC    DisplayError
        mov     cx, lenErrMessage       ; Length of common string
        mov     dx, offset errMessage   ; Address of common string
        call    DisplayString           ; Display first part message

        cmp     [exCode], codeAccess    ; Test for codeAccess err
        jne     @@10                    ; Jump if not this code
        mov     cx, lenErrAccess        ; Set string length
        mov     dx, offset errAccess    ; Set string address
        jmp     DisplayString           ; Display string
@@10:
        cmp     [exCode], codeNotOpen
        jne     @@20
        mov     cx, lenErrNotOpen
        mov     dx, offset errNotOpen
        jmp     DisplayString
@@20:
        cmp     [exCode], codeDiskFull
        jne     @@30
        mov     cx, lenErrDiskFull
        mov     dx, offset errDiskFull
        jmp     DisplayString
@@30:
        mov     cx, lenErrGeneral       ; Other error values
        mov     dx, offset errGeneral

DisplayString:
        mov     ah, 040h                ; Write-device function number
        mov     bx, ErrOutHandle        ; Specify error output handle
        int     21h                     ; Call DOS.  Write output.
        ret                             ; Return to caller

ENDP    DisplayError

        END     Start           ; End of program / entry point
