%TITLE "Display Key Values -- Copyright (c) 1989,1995 by Tom Swan"

        IDEAL

        MODEL   small
        STACK   256

cr      EQU     13      ; ASCII carriage return
lf      EQU     10      ; ASCII line feed


        DATASEG

exCode          DB      0
charKey         DB      'Character key : ', 0
funcKey         DB      'Function key  : ', 0
numString       DB      7 DUP (0)
welcome         DB      cr,lf,'Display Key Values--by Tom Swan'
                DB      cr,lf,'Press any key, or press Esc to quit'
                DB      cr,lf,lf,0


        CODESEG

;-----  From BINASC.OBJ
        EXTRN   BinToAscDec:proc

;-----  From STRIO.OBJ
        EXTRN   StrWrite:proc, NewLine:proc

;-----  From KEYBOARD.OBJ
        EXTRN   Keywaiting:proc, Getch:proc

Start:  
        mov     ax, @data               ; Initialize DS to address
        mov     ds, ax                  ;  of data segment
        mov     es, ax                  ; Make es = ds

        mov     di, offset welcome      ; Display welcome message
        call    StrWrite

Repeat:
        call    KeyWaiting              ; Wait for any keypress
        jz      Repeat                  ; Repeat until key waiting
        call    GetCh                   ; Read keypress
        mov     di, offset charKey      ; Address charKey string
        jnz     @@10                    ; Jump if key is a character
        cmp     al, 27                  ; Was Escape key pressed?
        je      Exit                    ; If yes, jump to exit
        mov     di, offset funcKey      ; Address funcKey string
@@10:
        call    StrWrite                ; Display key-type label
        xor     ah, ah                  ; Convert al to 16 bits
        mov     cx, 1                   ; Minimum number of digits
        mov     di, offset numString    ; Address number string
        call    BinToAscDec             ; Convert number to string
        call    StrWrite                ; Display key value
        call    NewLine                 ; Start new display line
        jmp     Repeat                  ; Get next keypress

Exit:
        mov     ah, 04Ch                ; DOS function: Exit program
        mov     al, [exCode]            ; Return exit code value
        int     21h                     ; Call DOS. Terminate program

        END     Start        ; End of program / entry point
