%TITLE "Pascal String-Filler Function -- Copyright (c) 1989,1995 by Tom Swan"

        IDEAL

        MODEL   TPASCAL

        CODESEG

        PUBLIC FillString

%NEWPAGE
;---------------------------------------------------------------
; FUNCTION FillString( n : Byte; ch : Char ) : String;
;---------------------------------------------------------------
PROC    FillString      NEAR
        ARG n:BYTE:2, c:BYTE:2 RETURNS string:dwORD

        les     di, [string]            ; es:di addresses fn result
        mov     al, [n]                 ; Load n into al
        cld                             ; Auto-increment di
        stosb                           ; Initialize string length
        xor     ch, ch                  ; Zero upper half of cx
        mov     cl, al                  ; cx = requested string len
        mov     al, [c]                 ; al = fill character
        jcxz    @@99                    ; Exit if length = 0
        repnz   stosb                   ; Store cx chars in string
@@99:
        ret                             ; Return to caller
ENDP    FillString

        END                     ; End of module
