%TITLE "Display PC Equipment Info -- by Tom Swan"

        IDEAL

        MODEL   small
        STACK   256


;-----  Equates

EOS     EQU     0       ; End of string terminator
cr      EQU     13      ; ASCII carriage return
lf      EQU     10      ; ASCII line feed


;-----  Define byte records with fields for equipment information

; !! NOTE : Type the line 20 on ONE line !!

RECORD Equip printers:2, x:1, game:1, ports:3, y:1, drives:2, mode:2, ram:2, z:1, disk:1


;-----  Define masks for isolating individual bit fields

;---------------------------------------
; AND Mask                      Field
;---------------------------------------
maskPrinters    =       MASK    printers
maskGame        =       MASK    game
maskPorts       =       MASK    ports
maskDrives      =       MASK    drives
maskMode        =       MASK    mode
maskDisk        =       MASK    disk


        DATASEG

exCode          db      0

welcome         db      cr,lf,'Equipment determination'
                db      cr,lf,'(C) 1995 by Tom Swan',cr,lf,lf,EOS

strPrinters     db      'Number of printers ........ ', EOS
strGame         db      'Game I/O port ............. ', EOS
strPorts        db      'Number of RS232 ports ..... ', EOS
strDrives       db      'Disk drives (minus 1) ..... ', EOS
strMode         db      'Initial video mode ........ ', EOS
strDisk         db      'Has disk drive (1=yes) .... ', EOS

string          db      40 DUP (?)      ; Work string


        CODESEG

;-----  From STRIO.OBJ and BINASC.OBJ

        EXTRN   BinToAscDec:proc, StrWrite:proc, NewLine:proc

Start:  
        mov     ax, @data       ; Initialize DS to address
        mov     ds, ax          ;  of data segment
        mov     es, ax          ; Make es = ds

        mov     di, OFFSET welcome      ; Address welcome message
        call    StrWrite                ; Display message
        int     11h                     ; BIOS equipment determination
        mov     bx, ax                  ; Save information in bx

        mov     di, OFFSET strPrinters  ; Address item label
        mov     dx, maskPrinters        ; Assign AND mask
        mov     cl, printers            ; Assign shift count
        call    ShowInfo                ; Display label and info

        mov     di, OFFSET strGame      ; Next item
        mov     dx, maskGame
        mov     cl, game
        call    ShowInfo

        mov     di, OFFSET strPorts     ; Next item
        mov     dx, maskPorts
        mov     cl, ports
        call    ShowInfo

        mov     di, OFFSET strDrives    ; Next item
        mov     dx, maskDrives
        mov     cl, drives
        call    ShowInfo

        mov     di, OFFSET strMode      ; Next item
        mov     dx, maskMode
        mov     cl, mode
        call    ShowInfo

        mov     di, OFFSET strDisk      ; Next item
        mov     dx, maskDisk
        mov     cl, disk
        call    ShowInfo

Exit:
        mov     ah, 04Ch                ; DOS function: Exit program
        mov     al, [exCode]            ; Return exit code value
        int     21h                     ; Call DOS. Terminate program
%NEWPAGE
;---------------------------------------------------------------
; ShowInfo      Display label and equipment value
;---------------------------------------------------------------
; Input:
;       bx = Equipment data from int 11h
;       cl = Bit field shift count
;       dx = Bit field AND-mask
;       di = Address of label string
; Output:
;       label and data value displayed
; Registers:
;       ax, cx
;---------------------------------------------------------------
PROC    ShowInfo
        mov     ax, bx                  ; Assign equipment value to ax
        and     ax, dx                  ; Isolate bit field in ax
        shr     ax, cl                  ; Shift field far right in ax
        call    StrWrite                ; Display label at di
        mov     di, OFFSET string       ; Address work string
        mov     cx, 1                   ; Request at least 1 digit
        call    BinToAscDec             ; Convert ax to ASCIIZ string
        call    StrWrite                ; Display string
        call    NewLine                 ; Start a new line
        ret                             ; Return to caller
ENDP    ShowInfo

        END     Start        ; End of program / entry point
