%TITLE "String Read Test -- by Tom Swan"

        IDEAL

        MODEL   small
        STACK   256

MaxLen  EQU     128     ; 128-character string
cr      EQU     13      ; ASCII carriage return
lf      EQU     10      ; ASCII line feed


        DATASEG

exCode          db      0
welcome         db      'Welcome to Echo-String', cr, lf
                db      'Type any string and press Enter', cr,lf,lf, 0
testString      db      MaxLen DUP (0), 0       ; MaxLen chars + null


        CODESEG

;-----  From STRIO.OBJ:

        EXTRN   StrRead:proc, StrWrite:proc, NewLine:proc

Start:  
        mov     ax, @data               ; Initialize DS to address
        mov     ds, ax                  ;  of data segment
        mov     es, ax                  ; Make ds=es

        mov     di, offset welcome      ; Display welcome message
        call    StrWrite

        mov     di, offset testString   ; di = address of testString
        mov     cx, MaxLen              ; cx = maximum len
        call    StrRead                 ; Read string from keyboard
        call    NewLine                 ; Start a new display line
        call    StrWrite                ; Echo string to display

Exit:
        mov     ah, 04Ch                ; DOS function: Exit program
        mov     al, [exCode]            ; Return exit code value
        int     21h                     ; Call DOS. Terminate program

        END     Start        ; End of program / entry point
