%TITLE "Display Disk Directory -- by Tom Swan"

        IDEAL

        MODEL   small
        STACK   256

FileName        EQU     30      ; Offset to file name in dirData


        DATASEG

exCode          DB      0

defaultSpec     DB      '*.*', 0        ; Default ASCIIZ wild card
DTAseg          DW      ?               ; Segment for DTA
DTAofs          DW      ?               ; Offset for DTA
dirData         DB      43 DUP (?)      ; Holds one directory entry


        CODESEG

;-----  From PARAMS.OBJ
        EXTRN   GetParams:Proc, GetOneParam:Proc, ParamCount:Proc

;-----  From STRINGS.OBJ, STRIO.OBJ
        EXTRN   StrLength:Proc, StrWrite:Proc, NewLine:Proc

Start:  
        mov     ax, @data               ; Set ax to data segment
        mov     es, ax                  ; Set es to data segment
        call    GetParams               ; Get parameters with ds = PSP
        call    NewLine                 ; Start new display line
        call    ParamCount              ; Get number of parameters (dx)
        mov     di, offset defaultSpec  ; Address default search string
        or      dx, dx                  ; Does dx = 0?
        jz      @@10                    ; Jump if dx (num params) = 0
        xor     cx, cx                  ; Else specify param #0
        call    GetOneParam             ; Get address of parameter
@@10:
        mov     bx, offset Action       ; Address action subroutine
        call    DirEngine               ; Scan directory entries
Exit:
        call    NewLine                 ; Start new display line
        mov     ah, 04Ch                ; DOS function: Exit program
        mov     al, [exCode]            ; Return exit code value
        int     21h                     ; Call DOS. Terminate program

%NEWPAGE
;---------------------------------------------------------------
; DirEngine     Directory scan "engine"
;---------------------------------------------------------------
; Input:
;       cs:bx = address of subroutine
;       ds:di = address of ASCIIZ search string (e.g. *.ASM)
; Output:
;       routine at cs:bx called for each directory entry match
; Registers:
;       ax, cx, dx + any changed in action subroutine at cs:bx
;---------------------------------------------------------------
PROC    DirEngine

;-----  Get current Disk Transfer Address (DTA) and save

        push    es                      ; Save registers modified
        push    bx                      ;  by DOS 2Fh function
        mov     ah, 2Fh                 ; DOS Get DTA function
        int     21h                     ; Get current DTA
        mov     [DTAseg], es            ; Save segment address
        mov     [DTAofs], bx            ; Save offset address
        pop     bx                      ; Restore registers
        pop     es

;-----  Set new DTA to global 43-byte dirData variable

        mov     dx, offset dirData      ; Address variable with ds:dx
        mov     ah, 1Ah                 ; DOS Set DTA function
        int     21h                     ; Set new DTA

;-----  Scan directory for matches to string at ds:dx

        mov     ah, 4Eh                 ; DOS Search-first function
        mov     cx, 10h                 ; Attribute--files + subdirs
        mov     dx, di                  ; Address string with ds:dx
        jmp     short @@20              ; Skip next assign to ah
@@10:
        mov     ah, 4Fh                 ; DOS Search-next function
@@20:
        int     21h                     ; Search first/next entry
        jc      @@99                    ; Exit on error or done
        call    bx                      ; Call Action subroutine
        jmp     @@10                    ; Repeat until done

;-----  Restore original DTA address

@@99:
        push    ds                      ; Preserve current ds
        mov     ds, [DTAseg]            ; Assign old DTA address
        mov     dx, [DTAofs]            ;  to ds:dx
        mov     ah, 1Ah                 ; DOS Set-DTA function
        int     21h                     ; Reset to old DTA
        pop     ds                      ; Restore ds
        ret                             ; Return to caller
ENDP    DirEngine
%NEWPAGE
;---------------------------------------------------------------
; Action        Called for each directory entry "hit"
;---------------------------------------------------------------
; Input:
;       dirData = directory entry (as returned by DOS)
; Output:
;       one file/subdirectory name displayed
; Registers:
;       ah, dl, cx, di
;---------------------------------------------------------------
PROC    Action
        mov     di, offset dirData + FileName
        call    StrWrite
        call    StrLength
        sub     cx, 16
        neg     cx
@@10:
        mov     ah, 2
        mov     dl, ' '
        int     21h
        loop    @@10
        ret                             ; Return to caller
ENDP    Action

        END     Start        ; End of program / entry point
